/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.requirejs.ConfigOption;
import org.netbeans.modules.javascript2.requirejs.RequireJsDataProvider;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.EditorUtils;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.editor.MappingCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.RequireJsCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.SimpleHandle;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndex;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RequireJSCodeCompletion
implements CompletionProvider {
    private static String HTML_TEXT = "html";
    private static String CLIENT_TEXT = "client";

    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        int offset;
        Snapshot snapshot = ccContext.getParserResult().getSnapshot();
        EditorUtils.CodeCompletionContext context = EditorUtils.findContext(snapshot, offset = snapshot.getEmbeddedOffset(ccContext.getCaretOffset()));
        if (context == EditorUtils.CodeCompletionContext.CONFIG_PROPERTY_NAME) {
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            Collection<String> names = RequireJsDataProvider.getDefault().getConfigurationOptions();
            for (String name : names) {
                if (!name.startsWith(prefix)) continue;
                ConfigOption option = null;
                try {
                    option = ConfigOption.getEnum(name);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (option != null) {
                    result.add(new RequireJsCompletionItem.PropertyNameCompletionItem(option.getName(), option.getType(), offset - prefix.length()));
                    continue;
                }
                result.add(new RequireJsCompletionItem.PropertyNameCompletionItem(name, ConfigOption.OptionType.UNKNOWN, offset - prefix.length()));
            }
            return result;
        }
        if (context == EditorUtils.CodeCompletionContext.CONFIG_BASE_URL_VALUE || context == EditorUtils.CodeCompletionContext.CONFIG_PATHS_VALUE || context == EditorUtils.CodeCompletionContext.REQUIRE_MODULE) {
            TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)snapshot.getTokenHierarchy(), (int)offset);
            if (ts == null) {
                return Collections.emptyList();
            }
            ts.move(offset);
            String writtenPath = prefix;
            boolean addExtensionInCC = false;
            if (ts.moveNext() && (ts.token().id() == JsTokenId.STRING_END || ts.token().id() == JsTokenId.STRING)) {
                if (ts.token().id() == JsTokenId.STRING_END) {
                    ts.movePrevious();
                }
                if (ts.token().id() == JsTokenId.STRING) {
                    String text = ts.token().text().toString();
                    writtenPath = text.substring(0, offset - ts.offset());
                }
            }
            if (writtenPath.startsWith("text!")) {
                addExtensionInCC = true;
            }
            writtenPath = FSCompletionUtils.removePlugin(writtenPath);
            FileObject fo = snapshot.getSource().getFileObject();
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            RequireJsIndex rIndex = null;
            if (fo != null && EditorUtils.isFileReference(snapshot, offset)) {
                FileObject fromMapping;
                FileObject targetFO;
                ArrayList<Object> relativeTo = new ArrayList<Object>();
                Collection<String> usedFileInDefine = EditorUtils.getUsedFileInDefine(snapshot, offset);
                for (String path : usedFileInDefine) {
                    targetFO = FSCompletionUtils.findMappedFileObject(path, fo);
                    String[] folders = path.split("/");
                    if (targetFO != null) {
                        for (int i = 0; i < folders.length; ++i) {
                            targetFO = targetFO.getParent();
                        }
                        if (relativeTo.contains(targetFO)) continue;
                        relativeTo.add(targetFO);
                        continue;
                    }
                    if (project == null || folders.length != 1) continue;
                    targetFO = fo.getParent();
                    while (!targetFO.equals(project.getProjectDirectory())) {
                        Enumeration children = targetFO.getChildren(false);
                        while (children.hasMoreElements()) {
                            FileObject child = (FileObject)children.nextElement();
                            if (!child.getName().startsWith(folders[folders.length - 1]) || relativeTo.contains(targetFO)) continue;
                            relativeTo.add(targetFO);
                        }
                        targetFO = targetFO.getParent();
                    }
                }
                if (project != null) {
                    try {
                        rIndex = RequireJsIndex.get(project);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if (!writtenPath.isEmpty() && writtenPath.indexOf(47) > -1) {
                        if (!writtenPath.startsWith("./")) {
                            String possiblePath = FSCompletionUtils.removePlugin(writtenPath.substring(0, writtenPath.lastIndexOf(47)));
                            targetFO = null;
                            for (FileObject parentFO = fo.getParent(); parentFO != null && !parentFO.equals(project.getProjectDirectory()); parentFO = parentFO.getParent()) {
                                targetFO = parentFO.getFileObject(possiblePath);
                                if (targetFO == null || relativeTo.contains(parentFO)) continue;
                                relativeTo.add(parentFO);
                            }
                        } else {
                            relativeTo.add(fo.getParent());
                        }
                    }
                }
                if (relativeTo.isEmpty() && rIndex != null) {
                    Collection<String> basePaths = rIndex.getBasePaths();
                    relativeTo.add(fo.getParent());
                    if (!basePaths.isEmpty()) {
                        for (String path : basePaths) {
                            FileObject findFO = FSCompletionUtils.findFileObject(fo, path, false);
                            if (findFO == null) continue;
                            relativeTo.add(findFO);
                        }
                    }
                }
                if (rIndex != null && project != null) {
                    Map<String, String> packages = rIndex.getPackages();
                    Collection<String> sourceRoots = rIndex.getSourceRoots();
                    if (packages != null && sourceRoots != null && writtenPath.contains("/")) {
                        String moduleName = writtenPath.substring(0, writtenPath.indexOf(47));
                        for (String sr : sourceRoots) {
                            String modulePath = packages.get(moduleName);
                            if (modulePath == null) continue;
                            List<String> pathParts = Arrays.asList(modulePath.split("/"));
                            int moduleIndex = pathParts.indexOf(moduleName);
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < moduleIndex; ++i) {
                                sb.append(pathParts.get(i)).append('/');
                            }
                            FileObject targetFo = project.getProjectDirectory().getFileObject(sr + '/' + sb.toString());
                            if (relativeTo.contains(targetFo)) continue;
                            relativeTo.add(targetFo);
                        }
                    }
                }
                ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
                HashMap<String, FSCompletionItem> ccItems = new HashMap<String, FSCompletionItem>();
                try {
                    boolean addPrefix = !this.isClientCode(project, fo);
                    List<CompletionProposal> tmpResult = FSCompletionUtils.computeRelativeItems(relativeTo, writtenPath, ccContext.getCaretOffset(), addExtensionInCC, addPrefix, new FSCompletionUtils.JSIncludesFilter(fo));
                    this.handleFileNameDuplicityInCC(tmpResult, ccItems, result);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!(result.isEmpty() && ccItems.isEmpty() || writtenPath.isEmpty() || writtenPath.charAt(0) != '/' && !writtenPath.startsWith("./") && !writtenPath.startsWith("../"))) {
                    result.addAll(ccItems.values());
                    return result;
                }
                if (writtenPath.isEmpty() && project != null) {
                    FileObject parentFolder = fo.getParent();
                    Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
                    Object topFolder = null;
                    if (!sourceRoots.isEmpty()) {
                        for (Object root : sourceRoots) {
                            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                            topFolder = root;
                            break;
                        }
                    }
                    if (topFolder == null) {
                        topFolder = project.getProjectDirectory();
                    }
                    try {
                        ArrayList<CompletionProposal> tmpResult = new ArrayList<CompletionProposal>();
                        while (FileUtil.isParentOf((FileObject)topFolder, (FileObject)parentFolder)) {
                            tmpResult.add(new FSCompletionItem(parentFolder, writtenPath, addExtensionInCC, offset));
                            parentFolder = parentFolder.getParent();
                        }
                        this.handleFileNameDuplicityInCC(tmpResult, ccItems, result);
                    }
                    catch (IOException tmpResult) {
                        // empty catch block
                    }
                }
                String prefixAfterMapping = "";
                int index = writtenPath.lastIndexOf(47);
                if (index > -1) {
                    fromMapping = FSCompletionUtils.findMappedFileObject(writtenPath.substring(0, index), fo);
                    prefixAfterMapping = writtenPath.substring(index + 1);
                } else {
                    fromMapping = FSCompletionUtils.findMappedFileObject(writtenPath, fo);
                }
                if (fromMapping != null) {
                    relativeTo.clear();
                    relativeTo.add(fromMapping);
                    try {
                        List<CompletionProposal> newItems = FSCompletionUtils.computeRelativeItems(relativeTo, prefixAfterMapping, ccContext.getCaretOffset(), addExtensionInCC, false, new FSCompletionUtils.JSIncludesFilter(fo));
                        this.handleFileNameDuplicityInCC(newItems, ccItems, result);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                HashMap<String, String> mappings = new HashMap<String, String>();
                if (rIndex != null) {
                    mappings.putAll(rIndex.getPathMappings(writtenPath));
                }
                mappings.putAll(RequireJsPreferences.getMappings(project));
                for (String mapping : mappings.keySet()) {
                    if (!mapping.startsWith(writtenPath)) continue;
                    result.add(new MappingCompletionItem(mapping, FSCompletionUtils.findMappedFileObject(mapping, fo), ccContext.getCaretOffset() - writtenPath.length()));
                }
                if (rIndex != null && (writtenPath.isEmpty() || !writtenPath.contains("!") && !writtenPath.contains("/"))) {
                    Collection<String> usedPlugins = rIndex.getUsedPlugins();
                    for (String plugin : usedPlugins) {
                        if (!plugin.startsWith(prefix)) continue;
                        result.add(new RequireJsCompletionItem.PluginNameCompletionItem(plugin, ccContext.getCaretOffset() - prefix.length()));
                    }
                }
                result.addAll(ccItems.values());
                return result;
            }
        }
        return Collections.emptyList();
    }

    private void handleFileNameDuplicityInCC(List<CompletionProposal> toCheck, Map<String, FSCompletionItem> ccItems, List<CompletionProposal> finalResult) {
        for (CompletionProposal next : toCheck) {
            if (next instanceof FSCompletionItem) {
                FSCompletionItem fsCC = (FSCompletionItem)next;
                String key = fsCC.getFile().getNameExt();
                if (!ccItems.containsKey(key)) {
                    ccItems.put(key, fsCC);
                    continue;
                }
                ((FSCompletionItem.FSElementHandle)ccItems.get(key).getElement()).addRepresentedFile(fsCC.getFile());
                continue;
            }
            finalResult.add(next);
        }
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        if (element instanceof FSCompletionItem.FSElementHandle) {
            Set<FileObject> representedFiles = ((FSCompletionItem.FSElementHandle)element).getRepresentedFiles();
            StringBuilder sb = new StringBuilder();
            for (FileObject next : representedFiles) {
                sb.append(FSCompletionUtils.writeFilePathForDocWindow(next));
                sb.append("</br>");
            }
            return sb.toString();
        }
        if (element instanceof SimpleHandle.DocumentationHandle) {
            return ((SimpleHandle.DocumentationHandle)element).getDocumentation();
        }
        return null;
    }

    private boolean isClientCode(Project project, FileObject source) {
        boolean result = false;
        String path = source.getPath();
        if (project == null) {
            return true;
        }
        if (FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)source)) {
            path = path.substring(project.getProjectDirectory().getPath().length());
        }
        result = (path = path.toLowerCase()).contains(HTML_TEXT) || path.contains(CLIENT_TEXT);
        return result;
    }
}

