/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;

public final class ProjectBrowserProviderImpl
implements ProjectBrowserProvider,
PropertyChangeListener {
    private final PhpProject project;
    final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private ProjectBrowserProviderImpl(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public static ProjectBrowserProvider create(PhpProject project) {
        ProjectBrowserProviderImpl projectBrowserProviderImpl = new ProjectBrowserProviderImpl(project);
        project.getEvaluator().addPropertyChangeListener((PropertyChangeListener)projectBrowserProviderImpl);
        return projectBrowserProviderImpl;
    }

    public Collection<WebBrowser> getBrowsers() {
        return WebBrowsers.getInstance().getAll(false, true, true);
    }

    public WebBrowser getActiveBrowser() {
        String browserId = this.project.getEvaluator().getProperty("browser.id");
        if (browserId == null) {
            return BrowserUISupport.getDefaultBrowserChoice((boolean)true);
        }
        return BrowserUISupport.getBrowser((String)browserId);
    }

    public void setActiveBrowser(WebBrowser browser) throws IOException {
        PhpProjectProperties.save(this.project, Collections.emptyMap(), Collections.singletonMap("browser.id", browser.getId()));
        this.propertyChangeSupport.firePropertyChange("activeConfiguration", null, null);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        PhpProjectUtils.openCustomizer(this.project, "Browser");
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.propertyChangeSupport.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.propertyChangeSupport.removePropertyChangeListener(lst);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("browser.id".equals(evt.getPropertyName())) {
            this.propertyChangeSupport.firePropertyChange("activeConfiguration", null, null);
        }
    }
}

