/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class CustomizeProject
extends ProjectAction
implements Presenter.Popup {
    private static final String namePattern = NbBundle.getMessage(CustomizeProject.class, (String)"LBL_CustomizeProjectAction_Name");
    private static final String namePatternPopup = NbBundle.getMessage(CustomizeProject.class, (String)"LBL_CustomizeProjectAction_Popup_Name");

    public CustomizeProject() {
        this((Lookup)null);
    }

    public CustomizeProject(Lookup context) {
        super((String)null, namePattern, namePatternPopup, null, context);
        this.refresh(this.getLookup(), true);
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        super.refresh(context, immediate);
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length != 1 || projects[0].getLookup().lookup(CustomizerProvider.class) == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(Lookup context) {
        final Pair<List<Project>, List<FileObject>> data = ActionsUtil.mineFromLookup(context);
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ CustomizeProject this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                CustomizerProvider cp;
                Project[] projects = ActionsUtil.getProjects((Pair<List<Project>, List<FileObject>>)data);
                if (projects.length == 1 && (cp = (CustomizerProvider)projects[0].getLookup().lookup(CustomizerProvider.class)) != null) {
                    if (!DataObject.getRegistry().getModifiedSet().isEmpty()) {
                        HashSet<DataObject> candidates = new HashSet<DataObject>();
                        List metadataFiles = ProjectOperations.getMetadataFiles((Project)projects[0]);
                        block0: for (DataObject dobj : DataObject.getRegistry().getModifiedSet()) {
                            if (projects[0] != FileOwnerQuery.getOwner((FileObject)dobj.getPrimaryFile())) continue;
                            for (FileObject df : metadataFiles) {
                                if (!df.equals(dobj.getPrimaryFile()) && (!df.isFolder() || !FileUtil.isParentOf((FileObject)df, (FileObject)dobj.getPrimaryFile()))) continue;
                                candidates.add(dobj);
                                continue block0;
                            }
                        }
                        if (!candidates.isEmpty()) {
                            String saveAll = NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.saveAll");
                            Object ret = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.save_modified_files"), NbBundle.getMessage(CustomizeProject.class, (String)"CustomizeProject.save_modified_title"), 2, 2, new Object[]{saveAll, NotifyDescriptor.CANCEL_OPTION}, (Object)saveAll));
                            if (ret != saveAll) {
                                return;
                            }
                            for (DataObject dobj : candidates) {
                                ExitDialog.doSave(dobj);
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            cp.showCustomizer();
                        }
                    });
                }
            }
        });
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new CustomizeProject(actionContext);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        JMenuItem popupPresenter = new JMenuItem();
        Actions.connect((JMenuItem)popupPresenter, (Action)this, (boolean)true);
        popupPresenter.setText(namePatternPopup);
        return popupPresenter;
    }
}

