/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cert.crmf;

import org.python.bouncycastle.asn1.ASN1Integer;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.DEROctetString;
import org.python.bouncycastle.asn1.cmp.CMPCertificate;
import org.python.bouncycastle.asn1.cmp.CertOrEncCert;
import org.python.bouncycastle.asn1.cmp.CertResponse;
import org.python.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.python.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.python.bouncycastle.asn1.cms.EnvelopedData;
import org.python.bouncycastle.asn1.crmf.EncryptedKey;
import org.python.bouncycastle.cert.X509CertificateHolder;
import org.python.bouncycastle.cert.crmf.CertificateResponse;
import org.python.bouncycastle.cms.CMSEnvelopedData;

public class CertificateResponseBuilder {
    private final ASN1Integer certReqId;
    private final PKIStatusInfo statusInfo;
    private CertifiedKeyPair certKeyPair;
    private ASN1OctetString rspInfo;

    public CertificateResponseBuilder(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo) {
        this.certReqId = aSN1Integer;
        this.statusInfo = pKIStatusInfo;
    }

    public CertificateResponseBuilder withCertificate(X509CertificateHolder x509CertificateHolder) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(new CMPCertificate(x509CertificateHolder.toASN1Structure())));
        return this;
    }

    public CertificateResponseBuilder withCertificate(CMPCertificate cMPCertificate) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(cMPCertificate));
        return this;
    }

    public CertificateResponseBuilder withCertificate(CMSEnvelopedData cMSEnvelopedData) {
        if (this.certKeyPair != null) {
            throw new IllegalStateException("certificate in response already set");
        }
        this.certKeyPair = new CertifiedKeyPair(new CertOrEncCert(new EncryptedKey(EnvelopedData.getInstance((Object)cMSEnvelopedData.toASN1Structure().getContent()))));
        return this;
    }

    public CertificateResponseBuilder withResponseInfo(byte[] byArray) {
        if (this.rspInfo != null) {
            throw new IllegalStateException("response info already set");
        }
        this.rspInfo = new DEROctetString(byArray);
        return this;
    }

    public CertificateResponse build() {
        return new CertificateResponse(new CertResponse(this.certReqId, this.statusInfo, this.certKeyPair, this.rspInfo));
    }
}

