/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.api;

import java.util.stream.Stream;
import org.freeplane.api.PhysicalUnit;
import org.freeplane.api.Quantity;

public enum LengthUnit implements PhysicalUnit
{
    px(1.0),
    in(72.0),
    mm(2.834645669291339),
    cm(28.346456692913385),
    pt(1.0);

    private double factor;

    private LengthUnit(double factor) {
        this.factor = factor;
    }

    @Override
    public double factor() {
        return this.factor;
    }

    public static Quantity<LengthUnit> pixelsInPt(double value) {
        return new Quantity<LengthUnit>(value, px).in(pt);
    }

    public static Quantity<LengthUnit> fromStringInPt(String value) {
        return Quantity.fromString(value, px).in(pt);
    }

    public static void setScalingFactor(double newFactor) {
        double factor = newFactor / LengthUnit.pt.factor;
        Stream.of(LengthUnit.values()).skip(1L).forEach(unit -> unit.factor *= factor);
    }
}

