﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/osis/OSISRequest.h>
#include <aws/osis/OSIS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace OSIS {
namespace Model {

/**
 */
class DeletePipelineEndpointRequest : public OSISRequest {
 public:
  AWS_OSIS_API DeletePipelineEndpointRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeletePipelineEndpoint"; }

  AWS_OSIS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of the pipeline endpoint to delete.</p>
   */
  inline const Aws::String& GetEndpointId() const { return m_endpointId; }
  inline bool EndpointIdHasBeenSet() const { return m_endpointIdHasBeenSet; }
  template <typename EndpointIdT = Aws::String>
  void SetEndpointId(EndpointIdT&& value) {
    m_endpointIdHasBeenSet = true;
    m_endpointId = std::forward<EndpointIdT>(value);
  }
  template <typename EndpointIdT = Aws::String>
  DeletePipelineEndpointRequest& WithEndpointId(EndpointIdT&& value) {
    SetEndpointId(std::forward<EndpointIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_endpointId;
  bool m_endpointIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace OSIS
}  // namespace Aws
