/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub.security;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Authentication.class);
    private String principal = "anonymous";
    private String ticket = "anonymous";
    private String roles = "";
    private final CloseableHttpClient client;
    private String loginEndpoint;
    private static final String CIPHER_ALGORITHM = "AES";
    private static final String CIPHER_MODE = "AES/CBC/PKCS5PADDING";
    private static final int IV_SIZE = 16;
    private static final String ZEPPELINHUB_USER_KEY = "zeppelinhub.user.key";
    private String token;
    private boolean authEnabled;
    private boolean authenticated;
    String userKey;
    private Gson gson = new Gson();
    private static Authentication instance = null;

    public static Authentication initialize(String token, ZeppelinConfiguration conf) {
        if (instance == null && conf != null) {
            instance = new Authentication(token, conf);
        }
        return instance;
    }

    public static Authentication getInstance() {
        return instance;
    }

    private Authentication(String token, ZeppelinConfiguration conf) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        this.token = token;
        this.authEnabled = !conf.isAnonymousAllowed();
        this.userKey = conf.getString("ZEPPELINHUB_USER_KEY", ZEPPELINHUB_USER_KEY, "");
        this.loginEndpoint = this.getLoginEndpoint(conf);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getTicket() {
        return this.ticket;
    }

    public String getRoles() {
        return this.roles;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    private String getLoginEndpoint(ZeppelinConfiguration conf) {
        int port = conf.getInt("ZEPPELIN_PORT", "zeppelin.server.port", 8080);
        if (port <= 0) {
            port = 8080;
        }
        String scheme = "http";
        if (conf.useSsl()) {
            scheme = "https";
        }
        return scheme + "://localhost:" + port + "/api/login";
    }

    public boolean authenticate() {
        if (this.authEnabled) {
            if (!StringUtils.isEmpty((CharSequence)this.userKey)) {
                String authKey = this.getAuthKey(this.userKey);
                Map<String, String> authCredentials = this.login(authKey, this.loginEndpoint);
                if (this.isEmptyMap(authCredentials)) {
                    return false;
                }
                this.principal = authCredentials.containsKey("principal") ? authCredentials.get("principal") : this.principal;
                this.ticket = authCredentials.containsKey("ticket") ? authCredentials.get("ticket") : this.ticket;
                this.roles = authCredentials.containsKey("roles") ? authCredentials.get("roles") : this.roles;
                LOG.info("Authenticated into Zeppelin as {} and roles {}", (Object)this.principal, (Object)this.roles);
                return true;
            }
            LOG.warn("ZEPPELINHUB_USER_KEY isn't provided. Please provide your credentialsfor your instance in ZeppelinHub website and generate your key.");
        }
        return false;
    }

    private String getAuthKey(String userKey) {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            LOG.warn("ZEPPELINHUB_USER_KEY is blank");
            return "";
        }
        String hashedToken = Integer.toString(this.token.hashCode());
        return this.decrypt(userKey, hashedToken);
    }

    private String decrypt(String value, String initVector) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)initVector)) {
            LOG.error("String to decode or salt is not provided");
            return "";
        }
        try {
            IvParameterSpec iv = this.generateIV(initVector);
            Key key = this.generateKey();
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, key, iv);
            byte[] decryptedString = Base64.decodeBase64((byte[])value.getBytes(StandardCharsets.UTF_8));
            decryptedString = cipher.doFinal(decryptedString);
            return new String(decryptedString);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Error when decrypting", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> login(String authKey, String endpoint) {
        String[] credentials = authKey.split(":");
        if (credentials.length != 2) {
            return Collections.emptyMap();
        }
        HttpPost post = new HttpPost(endpoint);
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        postParameters.add(new BasicNameValuePair("userName", credentials[0]));
        postParameters.add(new BasicNameValuePair("password", credentials[1]));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, StandardCharsets.UTF_8));
        post.addHeader("Origin", "http://localhost");
        try (CloseableHttpResponse postResponse = this.client.execute((HttpUriRequest)post);){
            if (postResponse.getStatusLine().getStatusCode() == 200) {
                String content = EntityUtils.toString((HttpEntity)postResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                Map resp = (Map)this.gson.fromJson(content, new TypeToken<Map<String, Object>>(){}.getType());
                LOG.info("Received from Zeppelin LoginRestApi : {}", (Object)content);
                Map map2 = (Map)resp.get("body");
                return map2;
            }
            LOG.error("Failed Zeppelin login {}, status code {}", (Object)endpoint, (Object)postResponse);
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        catch (IOException e) {
            LOG.error("Cannot login into Zeppelin", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Key generateKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(CIPHER_ALGORITHM);
            kgen.init(128, new SecureRandom());
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            return new SecretKeySpec(enCodeFormat, CIPHER_ALGORITHM);
        }
        catch (Exception e) {
            LOG.warn("Cannot generate key for decryption", (Throwable)e);
            return null;
        }
    }

    private IvParameterSpec generateIV(String ivString) {
        byte[] ivFromBytes = ivString.getBytes(StandardCharsets.UTF_8);
        byte[] iv16ToBytes = new byte[16];
        System.arraycopy(ivFromBytes, 0, iv16ToBytes, 0, Math.min(ivFromBytes.length, 16));
        return new IvParameterSpec(iv16ToBytes);
    }

    private boolean isEmptyMap(Map<String, String> map) {
        return map == null || map.isEmpty();
    }

    @Override
    public void run() {
        this.authenticated = this.authenticate();
        LOG.info("Scheduled authentication status is {}", (Object)this.authenticated);
    }
}

