/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zeppelin.interpreter.YarnAppMonitor;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.util.ProcessLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterManagedProcess
extends RemoteInterpreterProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterManagedProcess.class);
    private static final Pattern YARN_APP_PATTER = Pattern.compile("Submitted application (\\w+)");
    private final String interpreterRunner;
    private final String interpreterPortRange;
    private InterpreterProcessLauncher interpreterProcessLauncher;
    private String host = null;
    private int port = -1;
    private final String interpreterDir;
    private final String localRepoDir;
    private final String interpreterSettingName;
    private final String interpreterGroupId;
    private final boolean isUserImpersonated;
    private String errorMessage;
    private Map<String, String> env;

    public RemoteInterpreterManagedProcess(String intpRunner, int intpEventServerPort, String intpEventServerHost, String interpreterPortRange, String intpDir, String localRepoDir, Map<String, String> env, int connectTimeout, int connectionPoolSize, String interpreterSettingName, String interpreterGroupId, boolean isUserImpersonated) {
        super(connectTimeout, connectionPoolSize, intpEventServerHost, intpEventServerPort);
        this.interpreterRunner = intpRunner;
        this.interpreterPortRange = interpreterPortRange;
        this.env = env;
        this.interpreterDir = intpDir;
        this.localRepoDir = localRepoDir;
        this.interpreterSettingName = interpreterSettingName;
        this.interpreterGroupId = interpreterGroupId;
        this.isUserImpersonated = isUserImpersonated;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void start(String userName) throws IOException {
        CommandLine cmdLine = CommandLine.parse((String)this.interpreterRunner);
        cmdLine.addArgument("-d", false);
        cmdLine.addArgument(this.interpreterDir, false);
        cmdLine.addArgument("-c", false);
        cmdLine.addArgument(this.intpEventServerHost, false);
        cmdLine.addArgument("-p", false);
        cmdLine.addArgument(String.valueOf(this.intpEventServerPort), false);
        cmdLine.addArgument("-r", false);
        cmdLine.addArgument(this.interpreterPortRange, false);
        cmdLine.addArgument("-i", false);
        cmdLine.addArgument(this.interpreterGroupId, false);
        if (this.isUserImpersonated && !userName.equals("anonymous")) {
            cmdLine.addArgument("-u", false);
            cmdLine.addArgument(userName, false);
        }
        cmdLine.addArgument("-l", false);
        cmdLine.addArgument(this.localRepoDir, false);
        cmdLine.addArgument("-g", false);
        cmdLine.addArgument(this.interpreterSettingName, false);
        this.interpreterProcessLauncher = new InterpreterProcessLauncher(cmdLine, this.env);
        this.interpreterProcessLauncher.launch();
        this.interpreterProcessLauncher.waitForReady(this.getConnectTimeout());
        if (this.interpreterProcessLauncher.isLaunchTimeout()) {
            throw new IOException(String.format("Interpreter Process creation is time out in %d seconds", this.getConnectTimeout() / 1000) + "\nYou can increase timeout threshold via setting zeppelin.interpreter.connect.timeout of this interpreter.\n" + this.interpreterProcessLauncher.getErrorMessage());
        }
        if (!this.interpreterProcessLauncher.isRunning()) {
            throw new IOException("Fail to launch interpreter process:\n" + this.interpreterProcessLauncher.getErrorMessage());
        }
        String launchOutput = this.interpreterProcessLauncher.getProcessLaunchOutput();
        Matcher m = YARN_APP_PATTER.matcher(launchOutput);
        if (m.find()) {
            String appId = m.group(1);
            LOGGER.info("Detected yarn app: {}, add it to YarnAppMonitor", (Object)appId);
            YarnAppMonitor.get().addYarnApp(ConverterUtils.toApplicationId((String)appId), this);
        }
    }

    public void stop() {
        if (this.isRunning()) {
            LOGGER.info("Kill interpreter process for interpreter group: {}", (Object)this.getInterpreterGroupId());
            try {
                this.callRemoteFunction(client -> {
                    client.shutdown();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("ignore the exception when shutting down", (Throwable)e);
            }
            this.shutdown();
            this.interpreterProcessLauncher.stop();
            this.interpreterProcessLauncher = null;
            LOGGER.info("Remote process of interpreter group: {} is terminated", (Object)this.getInterpreterGroupId());
        }
    }

    @Override
    public void processStarted(int port, String host) {
        this.port = port;
        this.host = host;
        this.interpreterProcessLauncher.onProcessRunning();
    }

    public void processStopped(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @VisibleForTesting
    public Map<String, String> getEnv() {
        return this.env;
    }

    @VisibleForTesting
    public String getLocalRepoDir() {
        return this.localRepoDir;
    }

    @VisibleForTesting
    public String getInterpreterDir() {
        return this.interpreterDir;
    }

    public String getInterpreterSettingName() {
        return this.interpreterSettingName;
    }

    public String getInterpreterGroupId() {
        return this.interpreterGroupId;
    }

    @VisibleForTesting
    public String getInterpreterRunner() {
        return this.interpreterRunner;
    }

    @VisibleForTesting
    public boolean isUserImpersonated() {
        return this.isUserImpersonated;
    }

    public boolean isRunning() {
        return this.interpreterProcessLauncher != null && this.interpreterProcessLauncher.isRunning() && this.errorMessage == null;
    }

    @Override
    public String getErrorMessage() {
        String interpreterProcessError = this.interpreterProcessLauncher != null ? this.interpreterProcessLauncher.getErrorMessage() : "";
        return this.errorMessage != null ? this.errorMessage : interpreterProcessError;
    }

    private class InterpreterProcessLauncher
    extends ProcessLauncher {
        public InterpreterProcessLauncher(CommandLine commandLine, Map<String, String> envs) {
            super(commandLine, envs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForReady(int timeout) {
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                if (this.state != ProcessLauncher.State.RUNNING) {
                    try {
                        ((Object)((Object)this)).wait(timeout);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Remote interpreter is not accessible", (Throwable)e);
                    }
                }
            }
            this.stopCatchLaunchOutput();
            if (this.state == ProcessLauncher.State.LAUNCHED) {
                this.onTimeout();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessRunning() {
            super.onProcessRunning();
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessComplete(int exitValue) {
            LOGGER.warn("Process is exited with exit value " + exitValue);
            if (RemoteInterpreterManagedProcess.this.env.getOrDefault("ZEPPELIN_SPARK_YARN_CLUSTER", "false").equals("false")) {
                InterpreterProcessLauncher interpreterProcessLauncher = this;
                synchronized (interpreterProcessLauncher) {
                    ((Object)((Object)this)).notify();
                }
            }
            if (exitValue != 0) {
                this.transition(ProcessLauncher.State.TERMINATED);
            } else {
                this.transition(ProcessLauncher.State.COMPLETED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            InterpreterProcessLauncher interpreterProcessLauncher = this;
            synchronized (interpreterProcessLauncher) {
                ((Object)((Object)this)).notify();
            }
        }
    }
}

