/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.thrift.TException;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.ConfInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterContext;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.RemoteScheduler;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreter.class);
    private static final Gson GSON = new Gson();
    private String className;
    private String sessionId;
    private Interpreter.FormType formType;
    private RemoteInterpreterProcess interpreterProcess;
    private volatile boolean isOpened = false;
    private volatile boolean isCreated = false;

    public RemoteInterpreter(Properties properties, String sessionId, String className, String userName) {
        super(properties);
        this.sessionId = sessionId;
        this.className = className;
        this.setUserName(userName);
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    @VisibleForTesting
    public void setOpened(boolean opened) {
        this.isOpened = opened;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public synchronized RemoteInterpreterProcess getOrCreateInterpreterProcess() throws IOException {
        if (this.interpreterProcess != null) {
            return this.interpreterProcess;
        }
        ManagedInterpreterGroup intpGroup = this.getInterpreterGroup();
        this.interpreterProcess = intpGroup.getOrCreateInterpreterProcess(this.getUserName(), this.properties);
        return this.interpreterProcess;
    }

    public ManagedInterpreterGroup getInterpreterGroup() {
        return (ManagedInterpreterGroup)super.getInterpreterGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InterpreterException {
        RemoteInterpreter remoteInterpreter = this;
        synchronized (remoteInterpreter) {
            if (!this.isOpened) {
                for (Interpreter interpreter : this.getInterpreterGroup().getOrCreateSession(this.getUserName(), this.sessionId)) {
                    try {
                        if (interpreter instanceof ConfInterpreter) continue;
                        ((RemoteInterpreter)interpreter).internal_create();
                    }
                    catch (IOException e) {
                        throw new InterpreterException((Throwable)e);
                    }
                }
                this.interpreterProcess.callRemoteFunction(client -> {
                    LOGGER.info("Open RemoteInterpreter {}", (Object)this.getClassName());
                    ManagedInterpreterGroup managedInterpreterGroup = this.getInterpreterGroup();
                    synchronized (managedInterpreterGroup) {
                        if (!this.getInterpreterGroup().isAngularRegistryPushed()) {
                            this.pushAngularObjectRegistryToRemote((RemoteInterpreterService.Client)client);
                            this.getInterpreterGroup().setAngularRegistryPushed(true);
                        }
                    }
                    return null;
                });
                this.isOpened = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internal_create() throws IOException {
        RemoteInterpreter remoteInterpreter = this;
        synchronized (remoteInterpreter) {
            if (!this.isCreated) {
                this.interpreterProcess = this.getOrCreateInterpreterProcess();
                if (!this.interpreterProcess.isRunning()) {
                    throw new IOException("Interpreter process is not running\n" + this.interpreterProcess.getErrorMessage());
                }
                this.interpreterProcess.callRemoteFunction(client -> {
                    LOGGER.info("Create RemoteInterpreter {}", (Object)this.getClassName());
                    client.createInterpreter(this.getInterpreterGroup().getId(), this.sessionId, this.className, (Map)this.getProperties(), this.getUserName());
                    return null;
                });
                this.isCreated = true;
            }
        }
    }

    public void close() throws InterpreterException {
        if (this.isOpened) {
            RemoteInterpreterProcess interpreterProcess = null;
            try {
                interpreterProcess = this.getOrCreateInterpreterProcess();
            }
            catch (IOException e) {
                throw new InterpreterException((Throwable)e);
            }
            interpreterProcess.callRemoteFunction(client -> {
                client.close(this.sessionId, this.className);
                return null;
            });
            this.isOpened = false;
        } else {
            LOGGER.warn("close is called when RemoterInterpreter is not opened for {}", (Object)this.className);
        }
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("st:\n{}", (Object)st);
        }
        Interpreter.FormType form = this.getFormType();
        RemoteInterpreterProcess interpreterProcess = null;
        try {
            interpreterProcess = this.getOrCreateInterpreterProcess();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        if (!interpreterProcess.isRunning()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Interpreter process is not running\n" + interpreterProcess.getErrorMessage());
        }
        return (InterpreterResult)interpreterProcess.callRemoteFunction(client -> {
            RemoteInterpreterResult remoteResult = client.interpret(this.sessionId, this.className, st, this.convert(context));
            Map remoteConfig = (Map)GSON.fromJson(remoteResult.getConfig(), new TypeToken<Map<String, Object>>(){}.getType());
            context.getConfig().clear();
            if (remoteConfig != null) {
                context.getConfig().putAll(remoteConfig);
            }
            GUI currentGUI = context.getGui();
            GUI currentNoteGUI = context.getNoteGui();
            if (form == Interpreter.FormType.NATIVE) {
                GUI remoteGui = GUI.fromJson((String)remoteResult.getGui());
                GUI remoteNoteGui = GUI.fromJson((String)remoteResult.getNoteGui());
                currentGUI.clear();
                currentGUI.setParams(remoteGui.getParams());
                currentGUI.setForms(remoteGui.getForms());
                currentNoteGUI.setParams(remoteNoteGui.getParams());
                currentNoteGUI.setForms(remoteNoteGui.getForms());
            } else if (form == Interpreter.FormType.SIMPLE) {
                Map currentForms = currentGUI.getForms();
                Map currentParams = currentGUI.getParams();
                GUI remoteGUI = GUI.fromJson((String)remoteResult.getGui());
                Map remoteForms = remoteGUI.getForms();
                Map remoteParams = remoteGUI.getParams();
                currentForms.putAll(remoteForms);
                currentParams.putAll(remoteParams);
            }
            return this.convert(remoteResult);
        });
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        if (!this.isOpened) {
            LOGGER.warn("Cancel is called when RemoterInterpreter is not opened for {}", (Object)this.className);
            return;
        }
        RemoteInterpreterProcess interpreterProcess = null;
        try {
            interpreterProcess = this.getOrCreateInterpreterProcess();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        interpreterProcess.callRemoteFunction(client -> {
            client.cancel(this.sessionId, this.className, this.convert(context));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interpreter.FormType getFormType() throws InterpreterException {
        if (this.formType != null) {
            return this.formType;
        }
        RemoteInterpreter remoteInterpreter = this;
        synchronized (remoteInterpreter) {
            if (!this.isOpened) {
                this.open();
            }
        }
        RemoteInterpreterProcess interpreterProcess = null;
        try {
            interpreterProcess = this.getOrCreateInterpreterProcess();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        return (Interpreter.FormType)interpreterProcess.callRemoteFunction(client -> {
            this.formType = Interpreter.FormType.valueOf((String)client.getFormType(this.sessionId, this.className));
            return this.formType;
        });
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (!this.isOpened) {
            LOGGER.warn("getProgress is called when RemoterInterpreter is not opened for {}", (Object)this.className);
            return 0;
        }
        RemoteInterpreterProcess interpreterProcess = null;
        try {
            interpreterProcess = this.getOrCreateInterpreterProcess();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        return (Integer)interpreterProcess.callRemoteFunction(client -> client.getProgress(this.sessionId, this.className, this.convert(context)));
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        if (!this.isOpened) {
            this.open();
        }
        RemoteInterpreterProcess interpreterProcess = null;
        try {
            interpreterProcess = this.getOrCreateInterpreterProcess();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        return (List)interpreterProcess.callRemoteFunction(client -> client.completion(this.sessionId, this.className, buf, cursor, this.convert(interpreterContext)));
    }

    public String getStatus(String jobId) {
        if (!this.isOpened) {
            LOGGER.warn("getStatus is called when RemoteInterpreter is not opened for {}", (Object)this.className);
            return Job.Status.UNKNOWN.name();
        }
        RemoteInterpreterProcess interpreterProcess = null;
        try {
            interpreterProcess = this.getOrCreateInterpreterProcess();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (String)interpreterProcess.callRemoteFunction(client -> client.getStatus(this.sessionId, jobId));
    }

    public Scheduler getScheduler() {
        String executionMode = this.getProperty(".execution.mode", "paragraph");
        if (executionMode.equals("paragraph")) {
            RemoteScheduler s = new RemoteScheduler(RemoteInterpreter.class.getSimpleName() + "-" + this.getInterpreterGroup().getId() + "-" + this.sessionId, SchedulerFactory.singleton().getExecutor(), this);
            return SchedulerFactory.singleton().createOrGetScheduler((Scheduler)s);
        }
        if (executionMode.equals("note")) {
            String noteId = this.getProperty(".noteId");
            RemoteScheduler s = new RemoteScheduler(RemoteInterpreter.class.getSimpleName() + "-" + noteId, SchedulerFactory.singleton().getExecutor(), this);
            return SchedulerFactory.singleton().createOrGetScheduler((Scheduler)s);
        }
        throw new RuntimeException("Invalid execution mode: " + executionMode);
    }

    private RemoteInterpreterContext convert(InterpreterContext ic) {
        return new RemoteInterpreterContext(ic.getNoteId(), ic.getNoteName(), ic.getParagraphId(), ic.getReplName(), ic.getParagraphTitle(), ic.getParagraphText(), GSON.toJson((Object)ic.getAuthenticationInfo()), GSON.toJson((Object)ic.getConfig()), ic.getGui().toJson(), GSON.toJson((Object)ic.getNoteGui()), ic.getLocalProperties());
    }

    private InterpreterResult convert(RemoteInterpreterResult result) {
        InterpreterResult r = new InterpreterResult(InterpreterResult.Code.valueOf((String)result.getCode()));
        for (RemoteInterpreterResultMessage m : result.getMsg()) {
            r.add(InterpreterResult.Type.valueOf((String)m.getType()), m.getData());
        }
        return r;
    }

    private void pushAngularObjectRegistryToRemote(RemoteInterpreterService.Client client) throws TException {
        AngularObjectRegistry angularObjectRegistry = this.getInterpreterGroup().getAngularObjectRegistry();
        if (angularObjectRegistry != null && angularObjectRegistry.getRegistry() != null) {
            Map registry = angularObjectRegistry.getRegistry();
            LOGGER.info("Push local angular object registry from ZeppelinServer to remote interpreter group {}", (Object)this.getInterpreterGroup().getId());
            Type registryType = new TypeToken<Map<String, Map<String, AngularObject>>>(){}.getType();
            client.angularRegistryPush(GSON.toJson((Object)registry, registryType));
        }
    }

    public String toString() {
        return "RemoteInterpreter_" + this.className + "_" + this.sessionId;
    }
}

