/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sap.universe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.console.completer.Completer;
import jline.internal.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.sap.universe.UniverseCompleter;
import org.apache.zeppelin.sap.universe.UniverseNodeInfo;

public class UniverseNodeInfoCompleter
implements Completer {
    private final UniverseInfoTreeNode tree = new UniverseInfoTreeNode();

    public UniverseNodeInfoCompleter() {
    }

    public UniverseNodeInfoCompleter(Collection<UniverseNodeInfo> nodes) {
        Preconditions.checkNotNull(nodes);
        for (UniverseNodeInfo node : nodes) {
            String folder = node.getFolder();
            if (StringUtils.isBlank(folder)) {
                this.tree.putInfo(node);
                continue;
            }
            String[] path = folder.split("\\\\");
            UniverseInfoTreeNode universeInfoTreeNode = this.tree;
            for (String s : path) {
                universeInfoTreeNode = !universeInfoTreeNode.contains(s) ? universeInfoTreeNode.putFolder(s) : universeInfoTreeNode.getFolder(s);
            }
            universeInfoTreeNode.putInfo(node);
        }
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.completeCollection(buffer, cursor, candidates);
    }

    private int completeCollection(String buffer, int cursor, Collection candidates) {
        Preconditions.checkNotNull((Object)candidates);
        if (buffer == null) {
            candidates.addAll(this.tree.getNodesInfo());
        } else {
            String folder;
            String part = buffer.substring(0, cursor);
            ArrayList<String> path = new ArrayList<String>();
            path.addAll(Arrays.asList(part.split("\\]\\.\\[")));
            if (part.endsWith(UniverseCompleter.START_NAME.toString())) {
                path.add("");
            }
            UniverseInfoTreeNode treeNode = this.tree;
            for (int i = 0; !(i >= path.size() - 1 || treeNode.contains(folder = this.cleanName((String)path.get(i))) && (treeNode = treeNode.getFolder(folder)) == null); ++i) {
            }
            String p = this.cleanName((String)path.get(path.size() - 1)).toUpperCase();
            if (treeNode != null && treeNode.getChildren() != null) {
                if (p.isEmpty()) {
                    candidates.addAll(treeNode.getNodesInfo());
                } else {
                    for (UniverseNodeInfo universeNodeInfo : treeNode.getNodesInfo()) {
                        if (!universeNodeInfo.getName().toUpperCase().startsWith(p)) continue;
                        candidates.add(universeNodeInfo);
                    }
                }
            }
        }
        return candidates.isEmpty() ? -1 : 0;
    }

    private String cleanName(String name) {
        return name.replaceAll("\\[|\\]", "");
    }

    private class UniverseInfoTreeNode {
        private String name;
        private boolean isFolder;
        private Map<String, Object> children;

        public UniverseInfoTreeNode() {
            this.name = "/";
            this.isFolder = true;
            this.children = new HashMap<String, Object>();
        }

        public UniverseInfoTreeNode(String name) {
            this.name = name;
            this.isFolder = true;
            this.children = new HashMap<String, Object>();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public void setFolder(boolean folder) {
            this.isFolder = folder;
        }

        public Map<String, Object> getChildren() {
            return this.children;
        }

        public void setChildren(Map<String, Object> children) {
            this.children = children;
        }

        public boolean contains(String name) {
            return this.children.containsKey(name);
        }

        public UniverseInfoTreeNode getFolder(String name) {
            Object child = this.children.get(name);
            if (child instanceof UniverseInfoTreeNode) {
                return (UniverseInfoTreeNode)this.children.get(name);
            }
            return null;
        }

        public UniverseInfoTreeNode putFolder(String name) {
            UniverseInfoTreeNode newNode = new UniverseInfoTreeNode(name);
            this.children.put(name, newNode);
            return newNode;
        }

        public void putInfo(UniverseNodeInfo info) {
            this.children.put(info.getId(), info);
        }

        public Collection<UniverseNodeInfo> getNodesInfo() {
            HashMap<String, UniverseNodeInfo> map = new HashMap<String, UniverseNodeInfo>();
            if (this.children != null) {
                for (Object o : this.children.values()) {
                    if (o instanceof UniverseNodeInfo) {
                        UniverseNodeInfo nodeInfo = (UniverseNodeInfo)o;
                        map.put(nodeInfo.getName(), nodeInfo);
                        continue;
                    }
                    UniverseInfoTreeNode treeNode = (UniverseInfoTreeNode)o;
                    UniverseNodeInfo nodeInfo = new UniverseNodeInfo(treeNode.getName(), "folder");
                    if (map.containsKey(nodeInfo.getName())) continue;
                    map.put(nodeInfo.getName(), nodeInfo);
                }
            }
            return map.values();
        }
    }
}

