/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ksql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.ksql.BasicKSQLHttpClient;
import org.apache.zeppelin.ksql.KSQLRequest;
import org.apache.zeppelin.ksql.KSQLResponse;

public class KSQLRestService {
    private static final String KSQL_ENDPOINT = "%s/ksql";
    private static final String QUERY_ENDPOINT = "%s/query";
    private static final String KSQL_V1_CONTENT_TYPE = "application/vnd.ksql.v1+json; charset=utf-8";
    private static final List<String> KSQL_COMMON_FIELDS = Arrays.asList("statementText", "warnings", "@type");
    private static final String KSQL_URL = "ksql.url";
    private static final ObjectMapper json = new ObjectMapper();
    private final String ksqlUrl;
    private final String queryUrl;
    private final String baseUrl;
    private final Map<String, String> streamsProperties;
    private final Map<String, BasicKSQLHttpClient> clientCache;

    public KSQLRestService(Map<String, String> props) {
        this.baseUrl = Objects.requireNonNull(props.get(KSQL_URL), KSQL_URL).toString();
        this.ksqlUrl = String.format(KSQL_ENDPOINT, this.baseUrl);
        this.queryUrl = String.format(QUERY_ENDPOINT, this.baseUrl);
        this.clientCache = new ConcurrentHashMap<String, BasicKSQLHttpClient>();
        this.streamsProperties = props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("ksql.") && !((String)e.getKey()).equals(KSQL_URL)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    public void executeQuery(String paragraphId, String query, Consumer<KSQLResponse> callback) throws IOException {
        KSQLRequest request = new KSQLRequest(query, this.streamsProperties);
        if (this.isSelect(request)) {
            this.executeSelect(paragraphId, callback, request);
        } else if (this.isPrint(request)) {
            this.executePrint(paragraphId, callback, request);
        } else {
            this.executeKSQL(paragraphId, callback, request);
        }
    }

    private void executeKSQL(String paragraphId, Consumer<KSQLResponse> callback, KSQLRequest request) throws IOException {
        try (BasicKSQLHttpClient client = this.createNewClient(paragraphId, request, this.ksqlUrl);){
            List queryResponse = json.readValue(client.connect(), List.class);
            queryResponse.stream().map(map -> this.excludeKSQLCommonFields((Map<String, Object>)map)).flatMap(map -> map.entrySet().stream().filter(e -> e.getValue() instanceof List).flatMap(e -> ((List)e.getValue()).stream())).map(KSQLResponse::new).forEach(callback::accept);
            queryResponse.stream().map(map -> this.excludeKSQLCommonFields((Map<String, Object>)map)).flatMap(map -> map.entrySet().stream().filter(e -> e.getValue() instanceof Map).map(e -> (Map)e.getValue())).map(KSQLResponse::new).forEach(callback::accept);
        }
    }

    private Map<String, Object> excludeKSQLCommonFields(Map<String, Object> map) {
        return map.entrySet().stream().filter(e -> !KSQL_COMMON_FIELDS.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    private BasicKSQLHttpClient createNewClient(String paragraphId, KSQLRequest request, String url) throws IOException {
        BasicKSQLHttpClient client = new BasicKSQLHttpClient.Builder().withUrl(url).withJson(json.writeValueAsString(request)).withType("POST").withHeader("Content-type", KSQL_V1_CONTENT_TYPE).build();
        BasicKSQLHttpClient oldClient = this.clientCache.put(paragraphId, client);
        if (oldClient != null) {
            oldClient.close();
        }
        return client;
    }

    private void executeSelect(String paragraphId, final Consumer<KSQLResponse> callback, KSQLRequest request) throws IOException {
        final List<String> fieldNames = this.getFields(request);
        if (fieldNames.isEmpty()) {
            throw new RuntimeException("Field are empty");
        }
        try (final BasicKSQLHttpClient client = this.createNewClient(paragraphId, request, this.queryUrl);){
            client.connectAsync(new BasicKSQLHttpClient.BasicHTTPClientResponse(){

                @Override
                public void onMessage(int status, String message) {
                    try {
                        Map queryResponse = json.readValue(message, LinkedHashMap.class);
                        KSQLResponse resp = new KSQLResponse(fieldNames, queryResponse);
                        callback.accept(resp);
                        if (resp.isTerminal() || StringUtils.isNotBlank(resp.getErrorMessage()) || StringUtils.isNotBlank(resp.getFinalMessage())) {
                            client.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void onError(int status, String message) {
                    try {
                        KSQLResponse resp = new KSQLResponse(Collections.singletonMap("error", message));
                        callback.accept(resp);
                        client.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void executePrint(String paragraphId, final Consumer<KSQLResponse> callback, KSQLRequest request) throws IOException {
        try (final BasicKSQLHttpClient client = this.createNewClient(paragraphId, request, this.queryUrl);){
            client.connectAsync(new BasicKSQLHttpClient.BasicHTTPClientResponse(){

                @Override
                public void onMessage(int status, String message) {
                    if (message.toUpperCase().startsWith("FORMAT:")) {
                        return;
                    }
                    List<String> elements = Arrays.asList(message.split(","));
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                    row.put("timestamp", elements.get(0));
                    row.put("offset", elements.get(1));
                    row.put("record", String.join((CharSequence)"", elements.subList(2, elements.size())));
                    KSQLResponse resp = new KSQLResponse(row);
                    callback.accept(resp);
                }

                @Override
                public void onError(int status, String message) {
                    try {
                        KSQLResponse resp = new KSQLResponse(Collections.singletonMap("error", message));
                        callback.accept(resp);
                        client.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private boolean isSelect(KSQLRequest request) {
        return request.getKsql().toUpperCase().startsWith("SELECT");
    }

    private boolean isPrint(KSQLRequest request) {
        return request.getKsql().toUpperCase().startsWith("PRINT");
    }

    public void closeClient(String paragraphId) throws IOException {
        BasicKSQLHttpClient toClose = this.clientCache.remove(paragraphId);
        if (toClose != null) {
            toClose.close();
        }
    }

    private List<String> getFields(KSQLRequest request) throws IOException {
        return this.getFields(request, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getFields(KSQLRequest request, boolean tryCoerce) throws IOException {
        if (tryCoerce) {
            String query = request.getKsql().substring(0, request.getKsql().toUpperCase().indexOf("WHERE"));
            request = new KSQLRequest(query, request.getStreamsProperties());
        }
        try (BasicKSQLHttpClient client = new BasicKSQLHttpClient.Builder().withUrl(this.ksqlUrl).withJson(json.writeValueAsString(request.toExplainRequest())).withType("POST").withHeader("Content-type", KSQL_V1_CONTENT_TYPE).build();){
            List explainResponseList = json.readValue(client.connect(), List.class);
            Map explainResponse = (Map)explainResponseList.get(0);
            Map queryDescription = explainResponse.getOrDefault("queryDescription", Collections.emptyMap());
            List fields = queryDescription.getOrDefault("fields", Collections.emptyList());
            List<String> list = fields.stream().map(elem -> elem.getOrDefault("name", "").toString()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            if (tryCoerce) throw e;
            return this.getFields(request, true);
        }
    }

    public void close() {
        Set<String> keys = this.clientCache.keySet();
        keys.forEach(key -> {
            try {
                this.closeClient((String)key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

