/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ksql;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class KSQLResponse {
    private final Map<String, Object> row;
    private final String finalMessage;
    private final String errorMessage;
    private final boolean terminal;

    private <T, K, U> Collector<T, ?, Map<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }

    KSQLResponse(List<String> fields, Map<String, Object> row, String finalMessage, String errorMessage, boolean terminal) {
        List columns = row == null ? null : row.getOrDefault("columns", Collections.emptyList());
        this.row = row == null ? null : IntStream.range(0, columns.size()).mapToObj(index -> new AbstractMap.SimpleEntry(fields.get(index), columns.get(index))).collect(this.toLinkedHashMap(e -> (String)e.getKey(), e -> e.getValue()));
        this.finalMessage = finalMessage;
        this.errorMessage = errorMessage;
        this.terminal = terminal;
    }

    KSQLResponse(List<String> fields, Map<String, Object> resp) {
        this(fields, (Map)resp.get("row"), (String)resp.get("finalMessage"), (String)resp.get("errorMessage"), (Boolean)resp.get("terminal"));
    }

    KSQLResponse(Map<String, Object> resp) {
        this.row = resp;
        this.finalMessage = null;
        this.errorMessage = null;
        this.terminal = true;
    }

    public Map<String, Object> getRow() {
        return this.row;
    }

    public String getFinalMessage() {
        return this.finalMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isTerminal() {
        return this.terminal;
    }
}

