/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ksql;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class KSQLRequest {
    private static final String EXPLAIN_QUERY = "EXPLAIN %s";
    private final String ksql;
    private final Map<String, String> streamsProperties;

    KSQLRequest(String ksql, Map<String, String> streamsProperties) {
        String inputQuery = Objects.requireNonNull(ksql, "ksql").replaceAll("[\\n\\t\\r]", " ").trim();
        this.ksql = inputQuery.endsWith(";") ? inputQuery : inputQuery + ";";
        this.streamsProperties = streamsProperties;
    }

    KSQLRequest(String ksql) {
        this(ksql, Collections.emptyMap());
    }

    KSQLRequest toExplainRequest() {
        return new KSQLRequest(String.format(EXPLAIN_QUERY, this.ksql), this.streamsProperties);
    }

    public String getKsql() {
        return this.ksql;
    }

    public Map<String, String> getStreamsProperties() {
        return this.streamsProperties;
    }
}

