/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.FileSystemStorage;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.OldNoteInfo;
import org.apache.zeppelin.notebook.repo.FileSystemNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.OldNotebookRepo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldFileSystemNotebookRepo
implements OldNotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemNotebookRepo.class);
    private FileSystemStorage fs;
    private Path notebookDir;

    public void init(ZeppelinConfiguration zConf) throws IOException {
        this.fs = new FileSystemStorage(zConf, zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_DIR));
        LOGGER.info("Creating FileSystem: " + this.fs.getFs().getClass().getName() + " for Zeppelin Notebook.");
        this.notebookDir = this.fs.makeQualified(new Path(zConf.getNotebookDir()));
        LOGGER.info("Using folder {} to store notebook", (Object)this.notebookDir);
        this.fs.tryMkDir(this.notebookDir);
    }

    public List<OldNoteInfo> list(AuthenticationInfo subject) throws IOException {
        List notePaths = this.fs.list(new Path(this.notebookDir, "*/note.json"));
        ArrayList<OldNoteInfo> noteInfos = new ArrayList<OldNoteInfo>();
        for (Path path : notePaths) {
            OldNoteInfo noteInfo = new OldNoteInfo(path.getParent().getName(), "", null);
            noteInfos.add(noteInfo);
        }
        return noteInfos;
    }

    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        String content = this.fs.readFile(new Path(this.notebookDir.toString() + "/" + noteId + "/note.json"));
        return Note.fromJson((String)content);
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        this.fs.writeFile(note.toJson(), new Path(this.notebookDir.toString() + "/" + note.getId() + "/note.json"), true);
    }

    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        this.fs.delete(new Path(this.notebookDir.toString() + "/" + noteId));
    }

    public void close() {
        LOGGER.warn("close is not implemented for HdfsNotebookRepo");
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOGGER.warn("getSettings is not implemented for HdfsNotebookRepo");
        return null;
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOGGER.warn("updateSettings is not implemented for HdfsNotebookRepo");
    }
}

