/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import java.util.concurrent.ArrayBlockingQueue;

public class LatencyTracker {
    private static final ArrayBlockingQueue<String> Q = new ArrayBlockingQueue(256);
    private static final int MAXPERLINE = 3;
    private static volatile boolean disabled = false;

    private LatencyTracker() {
    }

    public static synchronized void disable() {
        disabled = true;
        Q.clear();
    }

    static void addLatency(String clientRequestId, int retryNum, long latency, String operation, long size, long clientId) {
        if (disabled) {
            return;
        }
        String line = String.format("%s.%d,%d,,%s,%d,%d", clientRequestId, retryNum, latency, operation, size, clientId);
        Q.offer(line);
    }

    static void addError(String clientRequestId, int retryNum, long latency, String error, String operation, long size, long clientId) {
        if (disabled) {
            return;
        }
        String line = String.format("%s.%d,%d,%s,%s,%d,%d", clientRequestId, retryNum, latency, error, operation, size, clientId);
        Q.offer(line);
    }

    static String get() {
        if (disabled) {
            return null;
        }
        String separator = "";
        StringBuilder line = new StringBuilder(6);
        String entry = Q.poll();
        if (entry == null) {
            return null;
        }
        for (int count = 0; entry != null && count < 3; ++count) {
            line.append(separator);
            line.append(entry);
            separator = ";";
            entry = Q.poll();
        }
        return line.toString();
    }
}

