/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.livy;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.livy.BaseLivyInterpreter;
import org.apache.zeppelin.livy.LivyException;
import org.apache.zeppelin.livy.LivySparkInterpreter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class LivySparkSQLInterpreter
extends BaseLivyInterpreter {
    public static final String ZEPPELIN_LIVY_SPARK_SQL_FIELD_TRUNCATE = "zeppelin.livy.spark.sql.field.truncate";
    public static final String ZEPPELIN_LIVY_SPARK_SQL_MAX_RESULT = "zeppelin.livy.spark.sql.maxResult";
    private LivySparkInterpreter sparkInterpreter;
    private String codeType = null;
    private boolean isSpark2 = false;
    private int maxResult = 1000;
    private boolean truncate = true;

    public LivySparkSQLInterpreter(Properties property) {
        super(property);
        this.maxResult = Integer.parseInt(property.getProperty(ZEPPELIN_LIVY_SPARK_SQL_MAX_RESULT));
        if (property.getProperty(ZEPPELIN_LIVY_SPARK_SQL_FIELD_TRUNCATE) != null) {
            this.truncate = Boolean.parseBoolean(property.getProperty(ZEPPELIN_LIVY_SPARK_SQL_FIELD_TRUNCATE));
        }
    }

    @Override
    public String getSessionKind() {
        return "spark";
    }

    @Override
    public void open() throws InterpreterException {
        this.sparkInterpreter = (LivySparkInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(LivySparkInterpreter.class));
        try {
            InterpreterContext context = InterpreterContext.builder().setInterpreterOut(new InterpreterOutput(null)).build();
            InterpreterResult result = this.sparkInterpreter.interpret("spark", context);
            if (result.code() == InterpreterResult.Code.SUCCESS && ((InterpreterResultMessage)result.message().get(0)).getData().contains("org.apache.spark.sql.SparkSession")) {
                LOGGER.info("SparkSession is detected so we are using spark 2.x for session {}", (Object)this.sparkInterpreter.getSessionInfo().id);
                this.isSpark2 = true;
            } else {
                result = this.sparkInterpreter.interpret("sqlContext", context);
                if (result.code() == InterpreterResult.Code.SUCCESS) {
                    LOGGER.info("sqlContext is detected.");
                } else if (result.code() == InterpreterResult.Code.ERROR) {
                    LOGGER.info("sqlContext is not detected, try to create SQLContext by ourselves");
                    result = this.sparkInterpreter.interpret("val sqlContext = new org.apache.spark.sql.SQLContext(sc)\nimport sqlContext.implicits._", context);
                    if (result.code() == InterpreterResult.Code.ERROR) {
                        throw new LivyException("Fail to create SQLContext," + ((InterpreterResultMessage)result.message().get(0)).getData());
                    }
                }
            }
        }
        catch (LivyException e) {
            throw new RuntimeException("Fail to Detect SparkVersion", (Throwable)((Object)e));
        }
    }

    @Override
    public InterpreterResult interpret(String line, InterpreterContext context) {
        try {
            if (StringUtils.isEmpty(line)) {
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
            }
            String sqlQuery = null;
            sqlQuery = this.isSpark2 ? "spark.sql(\"\"\"" + line + "\"\"\").show(" + this.maxResult + ", " + this.truncate + ")" : "sqlContext.sql(\"\"\"" + line + "\"\"\").show(" + this.maxResult + ", " + this.truncate + ")";
            InterpreterResult result = this.sparkInterpreter.interpret(sqlQuery, context);
            if (result.code() == InterpreterResult.Code.SUCCESS) {
                InterpreterResult result2 = new InterpreterResult(InterpreterResult.Code.SUCCESS);
                for (InterpreterResultMessage message : result.message()) {
                    if (message.getType() == InterpreterResult.Type.TEXT) {
                        List<String> rows = this.parseSQLOutput(message.getData());
                        result2.add(InterpreterResult.Type.TABLE, StringUtils.join(rows, "\n"));
                        if (rows.size() < this.maxResult + 1) continue;
                        result2.add(ResultMessages.getExceedsLimitRowsMessage((int)this.maxResult, (String)ZEPPELIN_LIVY_SPARK_SQL_MAX_RESULT));
                        continue;
                    }
                    result2.add(message.getType(), message.getData());
                }
                return result2;
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Exception in LivySparkSQLInterpreter while interpret ", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage((Exception)e));
        }
    }

    @Override
    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    protected List<String> parseSQLOutput(String output) {
        ArrayList<String> rows = new ArrayList<String>();
        String firstLine = output.split("\n", 2)[0];
        String[] tokens = StringUtils.split(firstLine, "\\+");
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        int start = 0;
        int end = 0;
        for (String token : tokens) {
            start = end + 1;
            end = start + token.length();
            pairs.add(new Pair(start, end));
        }
        int lineStart = 0;
        int lineEnd = firstLine.length();
        while (lineEnd < output.length()) {
            String line = output.substring(lineStart, lineEnd);
            if (line.matches("(?s)^\\|.*\\|$")) {
                ArrayList<String> cells = new ArrayList<String>();
                for (Pair pair : pairs) {
                    cells.add(StringEscapeUtils.escapeEcmaScript(line.substring(pair.start, pair.end)).trim());
                }
                rows.add(StringUtils.join(cells, "\t"));
            }
            lineEnd = (lineStart += firstLine.length() + 1) + firstLine.length();
        }
        return rows;
    }

    public boolean concurrentSQL() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.livy.concurrentSQL"));
    }

    public Scheduler getScheduler() {
        if (this.concurrentSQL()) {
            int maxConcurrency = 10;
            return SchedulerFactory.singleton().createOrGetParallelScheduler(LivySparkInterpreter.class.getName() + ((Object)((Object)this)).hashCode(), maxConcurrency);
        }
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getScheduler();
        }
        return null;
    }

    @Override
    public void cancel(InterpreterContext context) {
        if (this.sparkInterpreter != null) {
            this.sparkInterpreter.cancel(context);
        }
    }

    @Override
    public void close() {
        if (this.sparkInterpreter != null) {
            this.sparkInterpreter.close();
        }
    }

    @Override
    public int getProgress(InterpreterContext context) {
        if (this.sparkInterpreter != null) {
            return this.sparkInterpreter.getProgress(context);
        }
        return 0;
    }

    @Override
    protected String extractAppId() throws LivyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String extractWebUIAddress() throws LivyException {
        throw new UnsupportedOperationException();
    }

    private static class Pair {
        private int start;
        private int end;

        Pair(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

