/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.livy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.livy.APINotFoundException;
import org.apache.zeppelin.livy.LivyException;
import org.apache.zeppelin.livy.LivySharedInterpreter;
import org.apache.zeppelin.livy.LivyVersion;
import org.apache.zeppelin.livy.SessionDeadException;
import org.apache.zeppelin.livy.SessionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.security.kerberos.client.KerberosRestTemplate;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public abstract class BaseLivyInterpreter
extends Interpreter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseLivyInterpreter.class);
    private static Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String SESSION_NOT_FOUND_PATTERN = "(.*)\"Session '\\d+' not found.\"(.*)";
    protected volatile SessionInfo sessionInfo;
    private String livyURL;
    private int sessionCreationTimeout;
    private int pullStatusInterval;
    private int maxLogLines;
    protected boolean displayAppInfo;
    private boolean restartDeadSession;
    protected LivyVersion livyVersion;
    private RestTemplate restTemplate;
    private Map<String, String> customHeaders = new HashMap<String, String>();
    protected LivySharedInterpreter sharedInterpreter;
    Set<Object> paragraphsToCancel = Collections.newSetFromMap(new ConcurrentHashMap());
    private ConcurrentHashMap<String, Integer> paragraphId2StmtProgressMap = new ConcurrentHashMap();

    public BaseLivyInterpreter(Properties property) {
        super(property);
        this.livyURL = property.getProperty("zeppelin.livy.url");
        this.displayAppInfo = Boolean.parseBoolean(property.getProperty("zeppelin.livy.displayAppInfo", "true"));
        this.restartDeadSession = Boolean.parseBoolean(property.getProperty("zeppelin.livy.restart_dead_session", "false"));
        this.sessionCreationTimeout = Integer.parseInt(property.getProperty("zeppelin.livy.session.create_timeout", "120"));
        this.pullStatusInterval = Integer.parseInt(property.getProperty("zeppelin.livy.pull_status.interval.millis", "1000"));
        this.maxLogLines = Integer.parseInt(property.getProperty("zeppelin.livy.maxLogLines", "1000"));
        this.restTemplate = this.createRestTemplate();
        if (!StringUtils.isBlank(property.getProperty("zeppelin.livy.http.headers"))) {
            String[] headers;
            for (String header : headers = property.getProperty("zeppelin.livy.http.headers").split(";")) {
                String[] splits = header.split(":", -1);
                if (splits.length != 2) {
                    throw new RuntimeException("Invalid format of http headers: " + header + ", valid http header format is HEADER_NAME:HEADER_VALUE");
                }
                this.customHeaders.put(splits[0].trim(), this.envSubstitute(splits[1].trim()));
            }
        }
    }

    private String envSubstitute(String value) {
        String newValue = new String(value);
        Pattern pattern = Pattern.compile("\\$\\{(.*)\\}");
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String env = matcher.group(1);
            newValue = newValue.replace("${" + env + "}", System.getenv(env));
        }
        return newValue;
    }

    Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public abstract String getSessionKind();

    public void open() throws InterpreterException {
        try {
            this.livyVersion = this.getLivyVersion();
            if (this.livyVersion.isSharedSupported()) {
                this.sharedInterpreter = (LivySharedInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(LivySharedInterpreter.class));
            }
            if (this.sharedInterpreter == null || !this.sharedInterpreter.isSupported()) {
                this.initLivySession();
            }
        }
        catch (LivyException e) {
            String msg = "Fail to create session, please check livy interpreter log and livy server log";
            throw new InterpreterException(msg, (Throwable)((Object)e));
        }
    }

    public void close() {
        if (this.sharedInterpreter != null && this.sharedInterpreter.isSupported()) {
            this.sharedInterpreter.close();
            return;
        }
        if (this.sessionInfo != null) {
            this.closeSession(this.sessionInfo.id);
            this.sessionInfo = null;
        }
    }

    protected void initLivySession() throws LivyException {
        this.sessionInfo = this.createSession(this.getUserName(), this.getSessionKind());
        if (this.displayAppInfo) {
            if (this.sessionInfo.appId == null) {
                this.sessionInfo.appId = this.extractAppId();
            }
            this.sessionInfo.webUIAddress = this.sessionInfo.appInfo == null || StringUtils.isEmpty(this.sessionInfo.appInfo.get("sparkUiUrl")) ? this.extractWebUIAddress() : this.sessionInfo.appInfo.get("sparkUiUrl");
            LOGGER.info("Create livy session successfully with sessionId: {}, appId: {}, webUI: {}", this.sessionInfo.id, this.sessionInfo.appId, this.sessionInfo.webUIAddress);
        } else {
            LOGGER.info("Create livy session successfully with sessionId: {}", (Object)this.sessionInfo.id);
        }
    }

    protected abstract String extractAppId() throws LivyException;

    protected abstract String extractWebUIAddress() throws LivyException;

    public SessionInfo getSessionInfo() {
        if (this.sharedInterpreter != null && this.sharedInterpreter.isSupported()) {
            return this.sharedInterpreter.getSessionInfo();
        }
        return this.sessionInfo;
    }

    public String getCodeType() {
        if (this.getSessionKind().equalsIgnoreCase("pyspark3")) {
            return "pyspark";
        }
        return this.getSessionKind();
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        if (this.sharedInterpreter != null && this.sharedInterpreter.isSupported()) {
            return this.sharedInterpreter.interpret(st, this.getCodeType(), context);
        }
        if (StringUtils.isEmpty(st)) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
        }
        try {
            return this.interpret(st, null, context.getParagraphId(), this.displayAppInfo, true, true);
        }
        catch (LivyException e) {
            LOGGER.error("Fail to interpret: {}", (Object)st, (Object)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage((Exception)((Object)e)));
        }
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        List<InterpreterCompletion> candidates = Collections.emptyList();
        try {
            candidates = this.callCompletion(new CompletionRequest(buf, this.getSessionKind(), cursor));
        }
        catch (SessionNotFoundException e) {
            LOGGER.warn("Livy session {} is expired. Will return empty list of candidates.", (Object)this.getSessionInfo().id);
        }
        catch (LivyException le) {
            LOGGER.error("Failed to call code completions. Will return empty list of candidates", (Throwable)((Object)le));
        }
        return candidates;
    }

    private List<InterpreterCompletion> callCompletion(CompletionRequest req) throws LivyException {
        ArrayList<InterpreterCompletion> candidates = new ArrayList<InterpreterCompletion>();
        try {
            CompletionResponse resp = CompletionResponse.fromJson(this.callRestAPI("/sessions/" + this.getSessionInfo().id + "/completion", "POST", req.toJson()));
            for (String candidate : resp.candidates) {
                candidates.add(new InterpreterCompletion(candidate, candidate, ""));
            }
        }
        catch (APINotFoundException e) {
            LOGGER.debug("completion api seems not to be available. (available from livy 0.5)", (Throwable)((Object)e));
        }
        return candidates;
    }

    public void cancel(InterpreterContext context) {
        if (this.sharedInterpreter != null && this.sharedInterpreter.isSupported()) {
            this.sharedInterpreter.cancel(context);
            return;
        }
        this.paragraphsToCancel.add(context.getParagraphId());
        LOGGER.info("Added paragraph {} for cancellation.", (Object)context.getParagraphId());
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        if (this.sharedInterpreter != null && this.sharedInterpreter.isSupported()) {
            return this.sharedInterpreter.getProgress(context);
        }
        if (this.livyVersion.isGetProgressSupported()) {
            String paraId = context.getParagraphId();
            Integer progress = this.paragraphId2StmtProgressMap.get(paraId);
            return progress == null ? 0 : progress;
        }
        return 0;
    }

    private SessionInfo createSession(String user, String kind) throws LivyException {
        try {
            HashMap<String, String> conf = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
                if (!entry.getKey().toString().startsWith("livy.spark.") || entry.getValue().toString().isEmpty()) continue;
                conf.put(entry.getKey().toString().substring(5), entry.getValue().toString());
            }
            CreateSessionRequest request = new CreateSessionRequest(kind, user == null || user.equals("anonymous") ? null : user, conf);
            SessionInfo sessionInfo = SessionInfo.fromJson(this.callRestAPI("/sessions", "POST", request.toJson()));
            long start = System.currentTimeMillis();
            while (!sessionInfo.isReady()) {
                if ((System.currentTimeMillis() - start) / 1000L > (long)this.sessionCreationTimeout) {
                    String msg = "The creation of session " + sessionInfo.id + " is timeout within " + this.sessionCreationTimeout + " seconds, appId: " + sessionInfo.appId + ", log:\n" + StringUtils.join(this.getSessionLog((int)sessionInfo.id).log, "\n");
                    throw new LivyException(msg);
                }
                Thread.sleep(this.pullStatusInterval);
                sessionInfo = this.getSessionInfo(sessionInfo.id);
                LOGGER.info("Session {} is in state {}, appId {}", sessionInfo.id, sessionInfo.state, sessionInfo.appId);
                if (!sessionInfo.isFinished()) continue;
                String msg = "Session " + sessionInfo.id + " is finished, appId: " + sessionInfo.appId + ", log:\n" + StringUtils.join(this.getSessionLog((int)sessionInfo.id).log, "\n");
                throw new LivyException(msg);
            }
            return sessionInfo;
        }
        catch (Exception e) {
            LOGGER.error("Error when creating livy session for user {}", (Object)user, (Object)e);
            throw new LivyException(e);
        }
    }

    private SessionInfo getSessionInfo(int sessionId) throws LivyException {
        return SessionInfo.fromJson(this.callRestAPI("/sessions/" + sessionId, "GET"));
    }

    private SessionLog getSessionLog(int sessionId) throws LivyException {
        return SessionLog.fromJson(this.callRestAPI("/sessions/" + sessionId + "/log?size=" + this.maxLogLines, "GET"));
    }

    public InterpreterResult interpret(String code, String paragraphId, boolean displayAppInfo, boolean appendSessionExpired, boolean appendSessionDead) throws LivyException {
        return this.interpret(code, this.sharedInterpreter.isSupported() ? this.getSessionKind() : null, paragraphId, displayAppInfo, appendSessionExpired, appendSessionDead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String code, String codeType, String paragraphId, boolean displayAppInfo, boolean appendSessionExpired, boolean appendSessionDead) throws LivyException {
        StatementInfo stmtInfo = null;
        boolean sessionExpired = false;
        boolean sessionDead = false;
        try {
            InterpreterResult interpreterResult;
            try {
                stmtInfo = this.executeStatement(new ExecuteRequest(code, codeType));
            }
            catch (SessionNotFoundException e) {
                LOGGER.warn("Livy session {} is expired, new session will be created.", (Object)this.sessionInfo.id);
                sessionExpired = true;
                BaseLivyInterpreter baseLivyInterpreter = this;
                synchronized (baseLivyInterpreter) {
                    if (this.isSessionExpired()) {
                        this.initLivySession();
                    }
                }
                stmtInfo = this.executeStatement(new ExecuteRequest(code, codeType));
            }
            catch (SessionDeadException e) {
                sessionDead = true;
                if (this.restartDeadSession) {
                    LOGGER.warn("Livy session {} is dead, new session will be created.", (Object)this.sessionInfo.id);
                    this.close();
                    try {
                        this.open();
                    }
                    catch (InterpreterException ie) {
                        throw new LivyException("Fail to restart livy session", ie);
                    }
                    stmtInfo = this.executeStatement(new ExecuteRequest(code, codeType));
                }
                throw new LivyException("%html <font color=\"red\">Livy session is dead somehow, please check log to see why it is dead, and then restart livy interpreter</font>");
            }
            while (!stmtInfo.isAvailable()) {
                if (paragraphId != null && this.paragraphsToCancel.contains(paragraphId)) {
                    this.cancel(stmtInfo.id, paragraphId);
                    InterpreterResult e = new InterpreterResult(InterpreterResult.Code.ERROR, "Job is cancelled");
                    return e;
                }
                try {
                    Thread.sleep(this.pullStatusInterval);
                }
                catch (InterruptedException e) {
                    LOGGER.error("InterruptedException when pulling statement status.", e);
                    throw new LivyException(e);
                }
                stmtInfo = this.getStatementInfo(stmtInfo.id);
                if (paragraphId == null) continue;
                this.paragraphId2StmtProgressMap.put(paragraphId, (int)(stmtInfo.progress * 100.0));
            }
            if (appendSessionExpired || appendSessionDead) {
                interpreterResult = this.appendSessionExpireDead(this.getResultFromStatementInfo(stmtInfo, displayAppInfo), sessionExpired, sessionDead);
                return interpreterResult;
            }
            interpreterResult = this.getResultFromStatementInfo(stmtInfo, displayAppInfo);
            return interpreterResult;
        }
        finally {
            if (paragraphId != null) {
                this.paragraphId2StmtProgressMap.remove(paragraphId);
                this.paragraphsToCancel.remove(paragraphId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(int id, String paragraphId) {
        if (this.livyVersion.isCancelSupported()) {
            try {
                LOGGER.info("Cancelling statement {}", (Object)id);
                this.cancelStatement(id);
            }
            catch (LivyException e) {
                LOGGER.error("Fail to cancel statement {} for paragraph {}", new Object[]{id, paragraphId, e});
            }
            finally {
                this.paragraphsToCancel.remove(paragraphId);
            }
        } else {
            LOGGER.warn("cancel is not supported for this version of livy: {}", (Object)this.livyVersion);
            this.paragraphsToCancel.clear();
        }
    }

    protected LivyVersion getLivyVersion() throws LivyException {
        return new LivyVersion(LivyVersionResponse.fromJson((String)this.callRestAPI((String)"/version", (String)"GET")).version);
    }

    private boolean isSessionExpired() throws LivyException {
        try {
            this.getSessionInfo(this.sessionInfo.id);
            return false;
        }
        catch (SessionNotFoundException e) {
            return true;
        }
        catch (LivyException e) {
            throw e;
        }
    }

    private InterpreterResult appendSessionExpireDead(InterpreterResult result, boolean sessionExpired, boolean sessionDead) {
        InterpreterResult result2 = new InterpreterResult(result.code());
        if (sessionExpired) {
            result2.add(InterpreterResult.Type.HTML, "<font color=\"red\">Previous livy session is expired, new livy session is created. Paragraphs that depend on this paragraph need to be re-executed!</font>");
        }
        if (sessionDead) {
            result2.add(InterpreterResult.Type.HTML, "<font color=\"red\">Previous livy session is dead, new livy session is created. Paragraphs that depend on this paragraph need to be re-executed!</font>");
        }
        for (InterpreterResultMessage message : result.message()) {
            result2.add(message.getType(), message.getData());
        }
        return result2;
    }

    private InterpreterResult getResultFromStatementInfo(StatementInfo stmtInfo, boolean displayAppInfo) {
        if (stmtInfo.output != null && stmtInfo.output.isError()) {
            InterpreterResult result = new InterpreterResult(InterpreterResult.Code.ERROR);
            StringBuilder sb = new StringBuilder();
            sb.append(stmtInfo.output.evalue);
            if (!stmtInfo.output.evalue.contains("\n")) {
                sb.append("\n");
            }
            if (stmtInfo.output.traceback != null) {
                sb.append(StringUtils.join(stmtInfo.output.traceback));
            }
            result.add(sb.toString());
            return result;
        }
        if (stmtInfo.isCancelled()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Job is cancelled");
        }
        if (stmtInfo.output == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Empty output");
        }
        String result = stmtInfo.output.data.plainText;
        if (stmtInfo.output.data.applicationLivyTableJson != null) {
            StringBuilder outputBuilder = new StringBuilder();
            boolean notFirstColumn = false;
            for (Map header : stmtInfo.output.data.applicationLivyTableJson.headers) {
                if (notFirstColumn) {
                    outputBuilder.append("\t");
                }
                outputBuilder.append(header.get("name"));
                notFirstColumn = true;
            }
            outputBuilder.append("\n");
            for (List row : stmtInfo.output.data.applicationLivyTableJson.records) {
                outputBuilder.append(StringUtils.join(row, "\t"));
                outputBuilder.append("\n");
            }
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.TABLE, outputBuilder.toString());
        }
        if (stmtInfo.output.data.imagePng != null) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.IMG, stmtInfo.output.data.imagePng);
        }
        if (result != null && ((result = result.trim()).startsWith("<link") || result.startsWith("<script") || result.startsWith("<style") || result.startsWith("<div"))) {
            result = "%html " + result;
        }
        if (displayAppInfo) {
            InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS);
            interpreterResult.add(result);
            String appInfoHtml = "<hr/>Spark Application Id: " + this.sessionInfo.appId + "<br/>Spark WebUI: <a href=\"" + this.sessionInfo.webUIAddress + "\">" + this.sessionInfo.webUIAddress + "</a>";
            interpreterResult.add(InterpreterResult.Type.HTML, appInfoHtml);
            return interpreterResult;
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, result);
    }

    private StatementInfo executeStatement(ExecuteRequest executeRequest) throws LivyException {
        return StatementInfo.fromJson(this.callRestAPI("/sessions/" + this.sessionInfo.id + "/statements", "POST", executeRequest.toJson()));
    }

    private StatementInfo getStatementInfo(int statementId) throws LivyException {
        return StatementInfo.fromJson(this.callRestAPI("/sessions/" + this.sessionInfo.id + "/statements/" + statementId, "GET"));
    }

    private void cancelStatement(int statementId) throws LivyException {
        this.callRestAPI("/sessions/" + this.sessionInfo.id + "/statements/" + statementId + "/cancel", "POST");
    }

    private SSLContext getSslContext() {
        try {
            String trustStoreFile = this.getProperty("zeppelin.livy.ssl.trustStore");
            String trustStorePassword = this.getProperty("zeppelin.livy.ssl.trustStorePassword");
            String trustStoreType = this.getProperty("zeppelin.livy.ssl.trustStoreType", KeyStore.getDefaultType());
            if (StringUtils.isBlank(trustStoreFile)) {
                throw new RuntimeException("No zeppelin.livy.ssl.trustStore specified for livy ssl");
            }
            if (StringUtils.isBlank(trustStorePassword)) {
                throw new RuntimeException("No zeppelin.livy.ssl.trustStorePassword specified for livy ssl");
            }
            KeyStore trustStore = this.getStore(trustStoreFile, trustStoreType, trustStorePassword);
            SSLContextBuilder builder = SSLContexts.custom();
            builder.loadTrustMaterial(trustStore);
            String keyStoreFile = this.getProperty("zeppelin.livy.ssl.keyStore");
            String keyStorePassword = this.getProperty("zeppelin.livy.ssl.keyStorePassword");
            String keyPassword = this.getProperty("zeppelin.livy.ssl.keyPassword", keyStorePassword);
            String keyStoreType = this.getProperty("zeppelin.livy.ssl.keyStoreType", KeyStore.getDefaultType());
            if (StringUtils.isNotBlank(keyStoreFile)) {
                KeyStore keyStore = this.getStore(keyStoreFile, keyStoreType, keyStorePassword);
                builder.loadKeyMaterial(keyStore, keyPassword.toCharArray()).useTLS();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SSL Context", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getStore(String file, String type, String password) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            KeyStore trustStore = KeyStore.getInstance(type);
            trustStore.load(inputStream, password.toCharArray());
            KeyStore keyStore = trustStore;
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to open keystore " + file, e);
        }
    }

    private RestTemplate createRestTemplate() {
        String keytabLocation = this.getProperty("zeppelin.livy.keytab");
        String principal = this.getProperty("zeppelin.livy.principal");
        boolean isSpnegoEnabled = StringUtils.isNotEmpty(keytabLocation) && StringUtils.isNotEmpty(principal);
        CloseableHttpClient httpClient = null;
        if (this.livyURL.startsWith("https:")) {
            try {
                SSLContext sslContext = this.getSslContext();
                SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
                HttpClientBuilder httpClientBuilder = HttpClients.custom().setSSLSocketFactory(csf);
                if (isSpnegoEnabled) {
                    RequestConfig reqConfig = new RequestConfig(){

                        @Override
                        public boolean isAuthenticationEnabled() {
                            return true;
                        }
                    };
                    httpClientBuilder.setDefaultRequestConfig(reqConfig);
                    Credentials credentials = new Credentials(){

                        @Override
                        public String getPassword() {
                            return null;
                        }

                        @Override
                        public Principal getUserPrincipal() {
                            return null;
                        }
                    };
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(AuthScope.ANY, credentials);
                    httpClientBuilder.setDefaultCredentialsProvider(credsProvider);
                    Registry<AuthSchemeProvider> authSchemeProviderRegistry = RegistryBuilder.create().register("Negotiate", new SPNegoSchemeFactory()).build();
                    httpClientBuilder.setDefaultAuthSchemeRegistry(authSchemeProviderRegistry);
                }
                httpClient = httpClientBuilder.build();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create SSL HttpClient", e);
            }
        }
        RestTemplate restTemplate = isSpnegoEnabled ? (httpClient == null ? new KerberosRestTemplate(keytabLocation, principal) : new KerberosRestTemplate(keytabLocation, principal, httpClient)) : (httpClient == null ? new RestTemplate() : new RestTemplate(new HttpComponentsClientHttpRequestFactory(httpClient)));
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    private String callRestAPI(String targetURL, String method) throws LivyException {
        return this.callRestAPI(targetURL, method, "");
    }

    private String callRestAPI(String targetURL, String method, String jsonData) throws LivyException {
        targetURL = this.livyURL + targetURL;
        LOGGER.debug("Call rest api in {}, method: {}, jsonData: {}", targetURL, method, jsonData);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("X-Requested-By", "zeppelin");
        for (Map.Entry<String, String> entry : this.customHeaders.entrySet()) {
            headers.add(entry.getKey(), entry.getValue());
        }
        ResponseEntity<String> response = null;
        try {
            HttpEntity<String> entity;
            if (method.equals("POST")) {
                entity = new HttpEntity<String>(jsonData, headers);
                response = this.restTemplate.exchange(targetURL, HttpMethod.POST, entity, String.class, new Object[0]);
            } else if (method.equals("GET")) {
                entity = new HttpEntity(headers);
                response = this.restTemplate.exchange(targetURL, HttpMethod.GET, entity, String.class, new Object[0]);
            } else if (method.equals("DELETE")) {
                entity = new HttpEntity(headers);
                response = this.restTemplate.exchange(targetURL, HttpMethod.DELETE, entity, String.class, new Object[0]);
            }
        }
        catch (HttpClientErrorException e) {
            response = new ResponseEntity<String>(e.getResponseBodyAsString(), e.getStatusCode());
            LOGGER.error(String.format("Error with %s StatusCode: %s", response.getStatusCode().value(), e.getResponseBodyAsString()));
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof HttpClientErrorException) {
                HttpClientErrorException cause = (HttpClientErrorException)e.getCause();
                if (cause.getResponseBodyAsString().matches(SESSION_NOT_FOUND_PATTERN)) {
                    throw new SessionNotFoundException(cause.getResponseBodyAsString());
                }
                throw new LivyException(cause.getResponseBodyAsString() + "\n" + ExceptionUtils.getStackTrace(ExceptionUtils.getRootCause(e)));
            }
            if (e instanceof HttpServerErrorException) {
                HttpServerErrorException errorException = (HttpServerErrorException)e;
                String errorResponse = errorException.getResponseBodyAsString();
                if (errorResponse.contains("Session is in state dead")) {
                    throw new SessionDeadException();
                }
                throw new LivyException(errorResponse, e);
            }
            throw new LivyException(e);
        }
        if (response == null) {
            throw new LivyException("No http response returned");
        }
        LOGGER.debug("Get response, StatusCode: {}, responseBody: {}", (Object)response.getStatusCode(), response.getBody());
        if (response.getStatusCode().value() == 200 || response.getStatusCode().value() == 201) {
            return (String)response.getBody();
        }
        if (response.getStatusCode().value() == 404) {
            if (((String)response.getBody()).matches(SESSION_NOT_FOUND_PATTERN)) {
                throw new SessionNotFoundException((String)response.getBody());
            }
            throw new APINotFoundException("No rest api found for " + targetURL + ", " + (Object)((Object)response.getStatusCode()));
        }
        String responseString = (String)response.getBody();
        if (responseString.contains("CreateInteractiveRequest[\\\"master\\\"]")) {
            return responseString;
        }
        throw new LivyException(String.format("Error with %s StatusCode: %s", response.getStatusCode().value(), responseString));
    }

    private void closeSession(int sessionId) {
        try {
            this.callRestAPI("/sessions/" + sessionId, "DELETE");
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error closing session for user with session ID: %s", sessionId), e);
        }
    }

    private static class LivyVersionResponse {
        public String url;
        public String branch;
        public String revision;
        public String version;
        public String date;
        public String user;

        private LivyVersionResponse() {
        }

        public static LivyVersionResponse fromJson(String json) {
            return gson.fromJson(json, LivyVersionResponse.class);
        }
    }

    static class CompletionResponse {
        public final String[] candidates;

        CompletionResponse(String[] candidates) {
            this.candidates = candidates;
        }

        public static CompletionResponse fromJson(String json) {
            return gson.fromJson(json, CompletionResponse.class);
        }
    }

    static class CompletionRequest {
        public final String code;
        public final String kind;
        public final int cursor;

        CompletionRequest(String code, String kind, int cursor) {
            this.code = code;
            this.kind = kind;
            this.cursor = cursor;
        }

        public String toJson() {
            return gson.toJson(this);
        }
    }

    private static class StatementInfo {
        public Integer id;
        public String state;
        public double progress;
        public StatementOutput output;

        StatementInfo() {
        }

        public static StatementInfo fromJson(String json) {
            String rightJson;
            block2: {
                rightJson = "";
                try {
                    gson.fromJson(json, StatementInfo.class);
                    rightJson = json;
                }
                catch (Exception e) {
                    if (!json.contains("\"traceback\":{}")) break block2;
                    LOGGER.debug("traceback type mismatch, replacing the mismatching part ");
                    rightJson = json.replace("\"traceback\":{}", "\"traceback\":[]");
                    LOGGER.debug("new json string is {}", (Object)rightJson);
                }
            }
            return gson.fromJson(rightJson, StatementInfo.class);
        }

        public boolean isAvailable() {
            return this.state.equals("available") || this.state.equals("cancelled");
        }

        public boolean isCancelled() {
            return this.state.equals("cancelled");
        }

        private static class StatementOutput {
            public String status;
            public String executionCount;
            public Data data;
            public String ename;
            public String evalue;
            public String[] traceback;
            public TableMagic tableMagic;

            private StatementOutput() {
            }

            public boolean isError() {
                return this.status.equals("error");
            }

            public String toJson() {
                return gson.toJson(this);
            }

            private static class TableMagic {
                @SerializedName(value="headers")
                List<Map> headers;
                @SerializedName(value="data")
                List<List> records;

                private TableMagic() {
                }
            }

            private static class Data {
                @SerializedName(value="text/plain")
                public String plainText;
                @SerializedName(value="image/png")
                public String imagePng;
                @SerializedName(value="application/json")
                public String applicationJson;
                @SerializedName(value="application/vnd.livy.table.v1+json")
                public TableMagic applicationLivyTableJson;

                private Data() {
                }
            }
        }
    }

    static class ExecuteRequest {
        public final String code;
        public final String kind;

        ExecuteRequest(String code, String kind) {
            this.code = code;
            this.kind = kind;
        }

        public String toJson() {
            return gson.toJson(this);
        }
    }

    private static class SessionLog {
        public int id;
        public int from;
        public int size;
        public List<String> log;

        SessionLog() {
        }

        public static SessionLog fromJson(String json) {
            return gson.fromJson(json, SessionLog.class);
        }
    }

    public static class SessionInfo {
        public final int id;
        public String appId;
        public String webUIAddress;
        public final String owner;
        public final String proxyUser;
        public final String state;
        public final String kind;
        public final Map<String, String> appInfo;
        public final List<String> log;

        public SessionInfo(int id, String appId, String owner, String proxyUser, String state, String kind, Map<String, String> appInfo, List<String> log) {
            this.id = id;
            this.appId = appId;
            this.owner = owner;
            this.proxyUser = proxyUser;
            this.state = state;
            this.kind = kind;
            this.appInfo = appInfo;
            this.log = log;
        }

        public boolean isReady() {
            return this.state.equals("idle");
        }

        public boolean isFinished() {
            return this.state.equals("error") || this.state.equals("dead") || this.state.equals("success");
        }

        public static SessionInfo fromJson(String json) {
            return gson.fromJson(json, SessionInfo.class);
        }
    }

    private static class CreateSessionRequest {
        public final String kind;
        @SerializedName(value="proxyUser")
        public final String user;
        public final Map<String, String> conf;

        CreateSessionRequest(String kind, String user, Map<String, String> conf) {
            this.kind = kind;
            this.user = user;
            this.conf = conf;
        }

        public String toJson() {
            return gson.toJson(this);
        }
    }
}

