/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Arrays;
import org.apache.zeppelin.markdown.MarkdownParser;
import org.apache.zeppelin.markdown.UMLExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexmarkParser
implements MarkdownParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexmarkParser.class);
    private Parser parser;
    private HtmlRenderer renderer;

    public FlexmarkParser() {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(StrikethroughExtension.create(), TablesExtension.create(), UMLExtension.create(), AutolinkExtension.create(), WikiLinkExtension.create(), TypographicExtension.create()));
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    @Override
    public String render(String markdownText) {
        Document document = this.parser.parse(markdownText);
        String html = this.renderer.render((Node)document);
        return FlexmarkParser.wrapWithMarkdownClassDiv(html);
    }

    public static String wrapWithMarkdownClassDiv(String html) {
        return "<div class=\"markdown-body\">\n" + html + "\n</div>";
    }
}

