/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.join.BitDocIdSetFilter;
import org.apache.lucene.util.BitDocIdSet;

public class BitDocIdSetCachingWrapperFilter
extends BitDocIdSetFilter {
    private final Filter filter;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());

    public BitDocIdSetCachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    private BitDocIdSet docIdSetToCache(DocIdSet docIdSet, LeafReader reader) throws IOException {
        DocIdSetIterator it = docIdSet.iterator();
        if (it == null) {
            return null;
        }
        BitDocIdSet.Builder builder = new BitDocIdSet.Builder(reader.maxDoc());
        builder.or(it);
        return builder.build();
    }

    @Override
    public BitDocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        Object key = reader.getCoreCacheKey();
        DocIdSet docIdSet = this.cache.get(key);
        if (docIdSet == null) {
            docIdSet = this.filter.getDocIdSet(context, null);
            if ((docIdSet = this.docIdSetToCache(docIdSet, reader)) == null) {
                docIdSet = DocIdSet.EMPTY;
            }
            this.cache.put(key, docIdSet);
        }
        return docIdSet == DocIdSet.EMPTY ? null : (BitDocIdSet)docIdSet;
    }

    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + this.filter.toString(field) + ")";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BitDocIdSetCachingWrapperFilter other = (BitDocIdSetCachingWrapperFilter)o;
        return this.filter.equals((Object)other.filter);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.filter.hashCode();
    }
}

