/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class MappedFieldType
extends FieldType {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(MappedFieldType.class));
    private Names names;
    private float boost;
    private boolean docValues;
    private NamedAnalyzer indexAnalyzer;
    private NamedAnalyzer searchAnalyzer;
    private NamedAnalyzer searchQuoteAnalyzer;
    private SimilarityProvider similarity;
    private Loading normsLoading;
    private FieldDataType fieldDataType;
    private Object nullValue;
    private String nullValueAsString;

    protected MappedFieldType(MappedFieldType ref) {
        super(ref);
        this.names = ref.names();
        this.boost = ref.boost();
        this.docValues = ref.hasDocValues();
        this.indexAnalyzer = ref.indexAnalyzer();
        this.searchAnalyzer = ref.searchAnalyzer();
        this.searchQuoteAnalyzer = ref.searchQuoteAnalyzer();
        this.similarity = ref.similarity();
        this.normsLoading = ref.normsLoading();
        this.fieldDataType = ref.fieldDataType();
        this.nullValue = ref.nullValue();
        this.nullValueAsString = ref.nullValueAsString();
    }

    public MappedFieldType() {
        this.setTokenized(true);
        this.setStored(false);
        this.setStoreTermVectors(false);
        this.setOmitNorms(false);
        this.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.setBoost(1.0f);
        this.fieldDataType = new FieldDataType(this.typeName());
    }

    public abstract MappedFieldType clone();

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MappedFieldType fieldType = (MappedFieldType)o;
        if (this.similarity == null || fieldType.similarity == null ? this.similarity != fieldType.similarity : !Objects.equals(this.similarity.name(), fieldType.similarity.name())) {
            return false;
        }
        return this.boost == fieldType.boost && this.docValues == fieldType.docValues && Objects.equals(this.names, fieldType.names) && Objects.equals(this.indexAnalyzer, fieldType.indexAnalyzer) && Objects.equals(this.searchAnalyzer, fieldType.searchAnalyzer) && Objects.equals(this.searchQuoteAnalyzer(), fieldType.searchQuoteAnalyzer()) && Objects.equals((Object)this.normsLoading, (Object)fieldType.normsLoading) && Objects.equals(this.fieldDataType, fieldType.fieldDataType) && Objects.equals(this.nullValue, fieldType.nullValue) && Objects.equals(this.nullValueAsString, fieldType.nullValueAsString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.names, Float.valueOf(this.boost), this.docValues, this.indexAnalyzer, this.searchAnalyzer, this.searchQuoteAnalyzer, this.similarity == null ? null : this.similarity.name(), this.normsLoading, this.fieldDataType, this.nullValue, this.nullValueAsString});
    }

    public abstract String typeName();

    private final void checkTypeName(MappedFieldType other) {
        if (!this.typeName().equals(other.typeName())) {
            throw new IllegalArgumentException("mapper [" + this.names().fullName() + "] cannot be changed from type [" + this.typeName() + "] to [" + other.typeName() + "]");
        }
        if (this.getClass() != other.getClass()) {
            throw new IllegalStateException("Type names equal for class " + this.getClass().getSimpleName() + " and " + other.getClass().getSimpleName());
        }
    }

    public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
        boolean mergeWithIndexed;
        this.checkTypeName(other);
        boolean indexed = this.indexOptions() != IndexOptions.NONE;
        boolean bl = mergeWithIndexed = other.indexOptions() != IndexOptions.NONE;
        if (indexed != mergeWithIndexed || this.tokenized() != other.tokenized()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [index] values");
        }
        if (this.stored() != other.stored()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [store] values");
        }
        if (!this.hasDocValues() && other.hasDocValues()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [doc_values] values, cannot change from disabled to enabled");
        }
        if (this.omitNorms() && !other.omitNorms()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [omit_norms] values, cannot change from disable to enabled");
        }
        if (this.storeTermVectors() != other.storeTermVectors()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [store_term_vector] values");
        }
        if (this.storeTermVectorOffsets() != other.storeTermVectorOffsets()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [store_term_vector_offsets] values");
        }
        if (this.storeTermVectorPositions() != other.storeTermVectorPositions()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [store_term_vector_positions] values");
        }
        if (this.storeTermVectorPayloads() != other.storeTermVectorPayloads()) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [store_term_vector_payloads] values");
        }
        if (this.indexAnalyzer() == null || "default".equals(this.indexAnalyzer().name())) {
            if (other.indexAnalyzer() != null && !"default".equals(other.indexAnalyzer().name())) {
                conflicts.add("mapper [" + this.names().fullName() + "] has different [analyzer]");
            }
        } else if (other.indexAnalyzer() == null || "default".equals(other.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [analyzer]");
        } else if (!this.indexAnalyzer().name().equals(other.indexAnalyzer().name())) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [analyzer]");
        }
        if (!this.names().indexName().equals(other.names().indexName())) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [index_name]");
        }
        if (!Objects.equals(this.similarity(), other.similarity())) {
            conflicts.add("mapper [" + this.names().fullName() + "] has different [similarity]");
        }
        if (strict) {
            if (this.omitNorms() != other.omitNorms()) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [omit_norms] across all types.");
            }
            if (this.boost() != other.boost()) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [boost] across all types.");
            }
            if (this.normsLoading() != other.normsLoading()) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [norms.loading] across all types.");
            }
            if (!Objects.equals(this.searchAnalyzer(), other.searchAnalyzer())) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [search_analyzer] across all types.");
            }
            if (!Objects.equals(this.searchQuoteAnalyzer(), other.searchQuoteAnalyzer())) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [search_quote_analyzer] across all types.");
            }
            if (!Objects.equals(this.fieldDataType(), other.fieldDataType())) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [fielddata] across all types.");
            }
            if (!Objects.equals(this.nullValue(), other.nullValue())) {
                conflicts.add("mapper [" + this.names().fullName() + "] is used by multiple types. Set update_all_types to true to update [null_value] across all types.");
            }
        }
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isSortable() {
        return true;
    }

    public Names names() {
        return this.names;
    }

    public void setNames(Names names) {
        this.checkIfFrozen();
        this.names = names;
    }

    public float boost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.checkIfFrozen();
        this.boost = boost;
    }

    public FieldDataType fieldDataType() {
        return this.fieldDataType;
    }

    public void setFieldDataType(FieldDataType fieldDataType) {
        this.checkIfFrozen();
        this.fieldDataType = fieldDataType;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public void setHasDocValues(boolean hasDocValues) {
        this.checkIfFrozen();
        this.docValues = hasDocValues;
    }

    public Loading normsLoading() {
        return this.normsLoading;
    }

    public void setNormsLoading(Loading normsLoading) {
        this.checkIfFrozen();
        this.normsLoading = normsLoading;
    }

    public NamedAnalyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void setIndexAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.indexAnalyzer = analyzer;
    }

    public NamedAnalyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public void setSearchAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchAnalyzer = analyzer;
    }

    public NamedAnalyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer == null ? this.searchAnalyzer : this.searchQuoteAnalyzer;
    }

    public void setSearchQuoteAnalyzer(NamedAnalyzer analyzer) {
        this.checkIfFrozen();
        this.searchQuoteAnalyzer = analyzer;
    }

    public SimilarityProvider similarity() {
        return this.similarity;
    }

    public void setSimilarity(SimilarityProvider similarity) {
        this.checkIfFrozen();
        this.similarity = similarity;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public String nullValueAsString() {
        return this.nullValueAsString;
    }

    public void setNullValue(Object nullValue) {
        this.checkIfFrozen();
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    public Object value(Object value) {
        return value;
    }

    public Object valueForSearch(Object value) {
        return value;
    }

    public BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    public boolean useTermQueryWithQueryString() {
        return false;
    }

    protected Term createTerm(Object value) {
        return new Term(this.names().indexName(), this.indexedValueForSearch(value));
    }

    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        return new TermQuery(this.createTerm(value));
    }

    public Query termsQuery(List values, @Nullable QueryParseContext context) {
        BytesRef[] bytesRefs = new BytesRef[values.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values.get(i));
        }
        return new TermsQuery(this.names.indexName(), bytesRefs);
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
        if (!(this instanceof StringFieldType)) {
            DEPRECATION_LOGGER.deprecated("Range query on field [{}] of type [{}] is deprecated. The next version will only support it on text/keyword/numeric/date/ip fields", this.names().fullName(), this.typeName());
        }
        return new TermRangeQuery(this.names().indexName(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        if (!(this instanceof StringFieldType)) {
            DEPRECATION_LOGGER.deprecated("Fuzzy query on field [{}] of type [{}] is deprecated. The next version will only support it on text/keyword fields", this.names().fullName(), this.typeName());
        }
        return new FuzzyQuery(this.createTerm(value), fuzziness.asDistance(BytesRefs.toString(value)), prefixLength, maxExpansions, transpositions);
    }

    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        if (!(this instanceof StringFieldType)) {
            DEPRECATION_LOGGER.deprecated("Prefix query on field [{}] of type [{}] is deprecated. The next version will only support it on text/keyword fields", this.names().fullName(), this.typeName());
        }
        PrefixQuery query = new PrefixQuery(this.createTerm(value));
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    public Query regexpQuery(String value, int flags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, @Nullable QueryParseContext context) {
        if (this.numericType() != null) {
            throw new IllegalArgumentException("Cannot use regular expression to filter numeric field [" + this.names.fullName + "]");
        }
        if (!(this instanceof StringFieldType)) {
            DEPRECATION_LOGGER.deprecated("Regexp query on field [{}] of type [{}] is deprecated. The next version will only support it on text/keyword fields", this.names().fullName(), this.typeName());
        }
        RegexpQuery query = new RegexpQuery(this.createTerm(value), flags, maxDeterminizedStates);
        if (method != null) {
            query.setRewriteMethod(method);
        }
        return query;
    }

    public Query nullValueQuery() {
        if (this.nullValue == null) {
            return null;
        }
        return new ConstantScoreQuery(this.termQuery(this.nullValue, null));
    }

    public FieldStats stats(Terms terms, int maxDoc) throws IOException {
        return new FieldStats.Text(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), terms.getMin(), terms.getMax());
    }

    @Nullable
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    public static enum Loading {
        LAZY{

            public String toString() {
                return Loading.LAZY_VALUE;
            }
        }
        ,
        EAGER{

            public String toString() {
                return Loading.EAGER_VALUE;
            }
        }
        ,
        EAGER_GLOBAL_ORDINALS{

            public String toString() {
                return Loading.EAGER_GLOBAL_ORDINALS_VALUE;
            }
        };

        public static final String KEY = "loading";
        public static final String EAGER_GLOBAL_ORDINALS_VALUE = "eager_global_ordinals";
        public static final String EAGER_VALUE = "eager";
        public static final String LAZY_VALUE = "lazy";

        public static Loading parse(String loading, Loading defaultValue) {
            if (Strings.isNullOrEmpty(loading)) {
                return defaultValue;
            }
            if (EAGER_GLOBAL_ORDINALS_VALUE.equalsIgnoreCase(loading)) {
                return EAGER_GLOBAL_ORDINALS;
            }
            if (EAGER_VALUE.equalsIgnoreCase(loading)) {
                return EAGER;
            }
            if (LAZY_VALUE.equalsIgnoreCase(loading)) {
                return LAZY;
            }
            throw new MapperParsingException("Unknown [loading] value: [" + loading + "]");
        }
    }

    public static class Names {
        private final String indexName;
        private final String originalIndexName;
        private final String fullName;

        public Names(String name) {
            this(name, name, name);
        }

        public Names(String indexName, String originalIndexName, String fullName) {
            this.indexName = indexName;
            this.originalIndexName = originalIndexName;
            this.fullName = fullName;
        }

        public String indexName() {
            return this.indexName;
        }

        public String originalIndexName() {
            return this.originalIndexName;
        }

        public String fullName() {
            return this.fullName;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Names names = (Names)o;
            if (!this.fullName.equals(names.fullName)) {
                return false;
            }
            if (!this.indexName.equals(names.indexName)) {
                return false;
            }
            return this.originalIndexName.equals(names.originalIndexName);
        }

        public int hashCode() {
            int result = this.indexName.hashCode();
            result = 31 * result + this.originalIndexName.hashCode();
            result = 31 * result + this.fullName.hashCode();
            return result;
        }
    }
}

