/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.DjbHashFunction;
import org.elasticsearch.cluster.routing.HashFunction;
import org.elasticsearch.cluster.routing.SimpleHashFunction;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.script.ScriptService;

public class MetaDataIndexUpgradeService
extends AbstractComponent {
    private static final String DEPRECATED_SETTING_ROUTING_HASH_FUNCTION = "cluster.routing.operation.hash.type";
    private static final String DEPRECATED_SETTING_ROUTING_USE_TYPE = "cluster.routing.operation.use_type";
    private final Class<? extends HashFunction> pre20HashFunction;
    private final Boolean pre20UseType;
    private final ScriptService scriptService;
    private final MapperRegistry mapperRegistry;
    public static final Set<String> INDEX_BYTES_SIZE_SETTINGS = ImmutableSet.of("index.merge.policy.floor_segment", "index.merge.policy.max_merged_segment", "index.merge.policy.max_merge_size", "index.merge.policy.min_merge_size", "index.shard.recovery.file_chunk_size", "index.shard.recovery.translog_size", new String[]{"index.store.throttle.max_bytes_per_sec", "index.translog.flush_threshold_size", "index.translog.fs.buffer_size", "index.version_map_size"});
    public static final Set<String> INDEX_TIME_SETTINGS = ImmutableSet.of("index.gateway.wait_for_mapping_update_post_recovery", "index.shard.wait_for_mapping_update_post_recovery", "index.gc_deletes", "index.indexing.slowlog.threshold.index.debug", "index.indexing.slowlog.threshold.index.info", "index.indexing.slowlog.threshold.index.trace", new String[]{"index.indexing.slowlog.threshold.index.warn", "index.refresh_interval", "index.search.slowlog.threshold.fetch.debug", "index.search.slowlog.threshold.fetch.info", "index.search.slowlog.threshold.fetch.trace", "index.search.slowlog.threshold.fetch.warn", "index.search.slowlog.threshold.query.debug", "index.search.slowlog.threshold.query.info", "index.search.slowlog.threshold.query.trace", "index.search.slowlog.threshold.query.warn", "index.shadow.wait_for_initial_commit", "index.store.stats_refresh_interval", "index.translog.flush_threshold_period", "index.translog.interval", "index.translog.sync_interval", "index.unassigned.node_left.delayed_timeout"});

    @Inject
    public MetaDataIndexUpgradeService(Settings settings, ScriptService scriptService, MapperRegistry mapperRegistry) {
        super(settings);
        boolean hasCustomPre20HashFunction;
        this.scriptService = scriptService;
        this.mapperRegistry = mapperRegistry;
        String pre20HashFunctionName = settings.get(DEPRECATED_SETTING_ROUTING_HASH_FUNCTION, null);
        boolean bl = hasCustomPre20HashFunction = pre20HashFunctionName != null;
        if (hasCustomPre20HashFunction) {
            switch (pre20HashFunctionName) {
                case "Simple": 
                case "simple": 
                case "org.elasticsearch.cluster.routing.operation.hash.simple.SimpleHashFunction": {
                    this.pre20HashFunction = SimpleHashFunction.class;
                    break;
                }
                case "Djb": 
                case "djb": 
                case "org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction": {
                    this.pre20HashFunction = DjbHashFunction.class;
                    break;
                }
                default: {
                    try {
                        this.pre20HashFunction = Class.forName(pre20HashFunctionName).asSubclass(HashFunction.class);
                        break;
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        throw new ElasticsearchException("failed to load custom hash function [" + pre20HashFunctionName + "]", e, new Object[0]);
                    }
                }
            }
        } else {
            this.pre20HashFunction = DjbHashFunction.class;
        }
        this.pre20UseType = settings.getAsBoolean(DEPRECATED_SETTING_ROUTING_USE_TYPE, null);
        if (hasCustomPre20HashFunction || this.pre20UseType != null) {
            this.logger.warn("Settings [{}] and [{}] are deprecated. Index settings from your old indices have been updated to record the fact that they used some custom routing logic, you can now remove these settings from your `elasticsearch.yml` file", DEPRECATED_SETTING_ROUTING_HASH_FUNCTION, DEPRECATED_SETTING_ROUTING_USE_TYPE);
        }
    }

    public IndexMetaData upgradeIndexMetaData(IndexMetaData indexMetaData) {
        if (this.isUpgraded(indexMetaData)) {
            return indexMetaData;
        }
        this.checkSupportedVersion(indexMetaData);
        IndexMetaData newMetaData = this.upgradeLegacyRoutingSettings(indexMetaData);
        newMetaData = this.addDefaultUnitsIfNeeded(newMetaData);
        this.checkMappingsCompatibility(newMetaData);
        newMetaData = this.upgradeSettings(newMetaData);
        newMetaData = this.markAsUpgraded(newMetaData);
        return newMetaData;
    }

    IndexMetaData upgradeSettings(IndexMetaData indexMetaData) {
        String storeType = indexMetaData.getSettings().get("index.store.type");
        if (storeType != null) {
            String upgradeStoreType;
            switch (storeType.toLowerCase(Locale.ROOT)) {
                case "nio_fs": 
                case "niofs": {
                    upgradeStoreType = "niofs";
                    break;
                }
                case "mmap_fs": 
                case "mmapfs": {
                    upgradeStoreType = "mmapfs";
                    break;
                }
                case "simple_fs": 
                case "simplefs": {
                    upgradeStoreType = "simplefs";
                    break;
                }
                case "default": {
                    upgradeStoreType = "default";
                    break;
                }
                case "fs": {
                    upgradeStoreType = "fs";
                    break;
                }
                default: {
                    upgradeStoreType = storeType;
                }
            }
            if (!storeType.equals(upgradeStoreType)) {
                Settings indexSettings = Settings.builder().put(indexMetaData.getSettings()).put("index.store.type", upgradeStoreType).build();
                return IndexMetaData.builder(indexMetaData).version(indexMetaData.getVersion()).settings(indexSettings).build();
            }
        }
        return indexMetaData;
    }

    private boolean isUpgraded(IndexMetaData indexMetaData) {
        return indexMetaData.getUpgradeVersion().onOrAfter(Version.V_2_0_0_beta1);
    }

    private void checkSupportedVersion(IndexMetaData indexMetaData) {
        if (indexMetaData.getState() == IndexMetaData.State.OPEN && !MetaDataIndexUpgradeService.isSupportedVersion(indexMetaData)) {
            throw new IllegalStateException("The index [" + indexMetaData.getIndex() + "] was created before v0.90.0 and wasn't upgraded." + " This index should be open using a version before " + Version.CURRENT.minimumCompatibilityVersion() + " and upgraded using the upgrade API.");
        }
    }

    private static boolean isSupportedVersion(IndexMetaData indexMetaData) {
        if (indexMetaData.getCreationVersion().onOrAfter(Version.V_0_90_0_Beta1)) {
            return true;
        }
        return indexMetaData.getMinimumCompatibleVersion() != null && indexMetaData.getMinimumCompatibleVersion().onOrAfter(org.apache.lucene.util.Version.LUCENE_4_0_0);
    }

    private IndexMetaData upgradeLegacyRoutingSettings(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().get("index.legacy.routing.hash.type") == null && indexMetaData.getCreationVersion().before(Version.V_2_0_0_beta1)) {
            Settings indexSettings = Settings.builder().put(indexMetaData.getSettings()).put("index.legacy.routing.hash.type", this.pre20HashFunction).put("index.legacy.routing.use_type", this.pre20UseType == null ? false : this.pre20UseType).build();
            return IndexMetaData.builder(indexMetaData).version(indexMetaData.getVersion()).settings(indexSettings).build();
        }
        if (indexMetaData.getCreationVersion().onOrAfter(Version.V_2_0_0_beta1) && (indexMetaData.getSettings().get("index.legacy.routing.hash.type") != null || indexMetaData.getSettings().get("index.legacy.routing.use_type") != null)) {
            throw new IllegalStateException("Index [" + indexMetaData.getIndex() + "] created on or after 2.0 should NOT contain [" + "index.legacy.routing.hash.type" + "] + or [" + "index.legacy.routing.use_type" + "] in its index settings");
        }
        return indexMetaData;
    }

    private IndexMetaData addDefaultUnitsIfNeeded(IndexMetaData indexMetaData) {
        Settings settings;
        Settings newSettings;
        if (indexMetaData.getCreationVersion().before(Version.V_2_0_0_beta1) && (newSettings = MetaData.addDefaultUnitsIfNeeded(INDEX_TIME_SETTINGS, INDEX_BYTES_SIZE_SETTINGS, this.logger, settings = indexMetaData.getSettings())) != null) {
            return IndexMetaData.builder(indexMetaData).version(indexMetaData.getVersion()).settings(newSettings).build();
        }
        return indexMetaData;
    }

    private void checkMappingsCompatibility(IndexMetaData indexMetaData) {
        Index index = new Index(indexMetaData.getIndex());
        Settings settings = indexMetaData.getSettings();
        try {
            SimilarityLookupService similarityLookupService = new SimilarityLookupService(index, settings);
            try (FakeAnalysisService analysisService = new FakeAnalysisService(index, settings);
                 MapperService mapperService = new MapperService(index, settings, (AnalysisService)analysisService, similarityLookupService, this.scriptService, this.mapperRegistry);){
                for (ObjectCursor<MappingMetaData> objectCursor : indexMetaData.getMappings().values()) {
                    MappingMetaData mappingMetaData = (MappingMetaData)objectCursor.value;
                    mapperService.merge(mappingMetaData.type(), mappingMetaData.source(), MapperService.MergeReason.MAPPING_RECOVERY, false);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + indexMetaData.getIndex() + "], reason: [" + ex.getMessage() + "]", ex);
        }
    }

    private IndexMetaData markAsUpgraded(IndexMetaData indexMetaData) {
        Settings settings = Settings.builder().put(indexMetaData.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetaData.builder(indexMetaData).settings(settings).build();
    }

    private static class FakeAnalysisService
    extends AnalysisService {
        private Analyzer fakeAnalyzer = new Analyzer(){

            @Override
            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                throw new UnsupportedOperationException("shouldn't be here");
            }
        };

        public FakeAnalysisService(Index index, Settings indexSettings) {
            super(index, indexSettings);
        }

        @Override
        public NamedAnalyzer analyzer(String name) {
            return new NamedAnalyzer(name, this.fakeAnalyzer);
        }

        @Override
        public void close() {
            this.fakeAnalyzer.close();
            super.close();
        }
    }
}

