/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermQueryConstantScoreWrapper;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.spatial.util.GeoEncodingUtils;
import org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.lucene.spatial.util.GeoUtils;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.SloppyMath;

abstract class GeoPointMultiTermQuery
extends MultiTermQuery {
    protected final double minLon;
    protected final double minLat;
    protected final double maxLon;
    protected final double maxLat;
    protected final short maxShift;
    protected final GeoPointField.TermEncoding termEncoding;
    protected final CellComparator cellComparator;
    public static final MultiTermQuery.RewriteMethod GEO_CONSTANT_SCORE_REWRITE = new MultiTermQuery.RewriteMethod(){

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            return new GeoPointTermQueryConstantScoreWrapper<GeoPointMultiTermQuery>((GeoPointMultiTermQuery)query);
        }
    };

    public GeoPointMultiTermQuery(String field, GeoPointField.TermEncoding termEncoding, double minLon, double minLat, double maxLon, double maxLat) {
        super(field);
        if (!GeoUtils.isValidLon(minLon)) {
            throw new IllegalArgumentException("invalid minLon " + minLon);
        }
        if (!GeoUtils.isValidLon(maxLon)) {
            throw new IllegalArgumentException("invalid maxLon " + maxLon);
        }
        if (!GeoUtils.isValidLat(minLat)) {
            throw new IllegalArgumentException("invalid minLat " + minLat);
        }
        if (!GeoUtils.isValidLat(maxLat)) {
            throw new IllegalArgumentException("invalid maxLat " + maxLat);
        }
        long minHash = GeoEncodingUtils.mortonHash(minLon, minLat);
        long maxHash = GeoEncodingUtils.mortonHash(maxLon, maxLat);
        this.minLon = GeoEncodingUtils.mortonUnhashLon(minHash);
        this.minLat = GeoEncodingUtils.mortonUnhashLat(minHash);
        this.maxLon = GeoEncodingUtils.mortonUnhashLon(maxHash);
        this.maxLat = GeoEncodingUtils.mortonUnhashLat(maxHash);
        this.maxShift = this.computeMaxShift();
        this.termEncoding = termEncoding;
        this.cellComparator = this.newCellComparator();
        this.rewriteMethod = GEO_CONSTANT_SCORE_REWRITE;
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return GeoPointTermsEnum.newInstance(terms.iterator(), this);
    }

    protected short computeMaxShift() {
        double midLat = (this.minLat + this.maxLat) * 0.5;
        double midLon = (this.minLon + this.maxLon) * 0.5;
        int shiftFactor = SloppyMath.haversin(this.minLat, this.minLon, midLat, midLon) * 1000.0 > 1000000.0 ? 5 : 4;
        return (short)(9 * shiftFactor);
    }

    protected abstract CellComparator newCellComparator();

    static abstract class CellComparator {
        protected final GeoPointMultiTermQuery geoPointQuery;

        CellComparator(GeoPointMultiTermQuery query) {
            this.geoPointQuery = query;
        }

        protected boolean cellIntersectsMBR(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectIntersects(minLon, minLat, maxLon, maxLat, this.geoPointQuery.minLon, this.geoPointQuery.minLat, this.geoPointQuery.maxLon, this.geoPointQuery.maxLat);
        }

        protected boolean cellContains(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectWithin(this.geoPointQuery.minLon, this.geoPointQuery.minLat, this.geoPointQuery.maxLon, this.geoPointQuery.maxLat, minLon, minLat, maxLon, maxLat);
        }

        protected abstract boolean cellCrosses(double var1, double var3, double var5, double var7);

        protected abstract boolean cellWithin(double var1, double var3, double var5, double var7);

        protected abstract boolean cellIntersectsShape(double var1, double var3, double var5, double var7);

        protected abstract boolean postFilter(double var1, double var3);
    }
}

