/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;

public abstract class AbstractSecondPassGroupingCollector<GROUP_VALUE_TYPE>
extends SimpleCollector {
    private final Collection<SearchGroup<GROUP_VALUE_TYPE>> groups;
    private final Sort groupSort;
    private final Sort withinGroupSort;
    private final int maxDocsPerGroup;
    private final boolean needsScores;
    protected final Map<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>> groupMap;
    protected SearchGroupDocs<GROUP_VALUE_TYPE>[] groupDocs;
    private int totalHitCount;
    private int totalGroupedHitCount;

    public AbstractSecondPassGroupingCollector(Collection<SearchGroup<GROUP_VALUE_TYPE>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("no groups to collect (groups is empty)");
        }
        this.groups = Objects.requireNonNull(groups);
        this.groupSort = Objects.requireNonNull(groupSort);
        this.withinGroupSort = Objects.requireNonNull(withinGroupSort);
        this.maxDocsPerGroup = maxDocsPerGroup;
        this.needsScores = getScores || getMaxScores || withinGroupSort.needsScores();
        this.groupMap = new HashMap<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>>(groups.size());
        for (SearchGroup<GROUP_VALUE_TYPE> group : groups) {
            TopDocsCollector collector = withinGroupSort.equals(Sort.RELEVANCE) ? TopScoreDocCollector.create(maxDocsPerGroup) : TopFieldCollector.create(withinGroupSort, maxDocsPerGroup, fillSortFields, getScores, getMaxScores);
            this.groupMap.put(group.groupValue, new SearchGroupDocs(group.groupValue, collector));
        }
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        for (SearchGroupDocs<GROUP_VALUE_TYPE> group : this.groupMap.values()) {
            group.leafCollector.setScorer(scorer);
        }
    }

    @Override
    public void collect(int doc) throws IOException {
        ++this.totalHitCount;
        SearchGroupDocs<GROUP_VALUE_TYPE> group = this.retrieveGroup(doc);
        if (group != null) {
            ++this.totalGroupedHitCount;
            group.leafCollector.collect(doc);
        }
    }

    protected abstract SearchGroupDocs<GROUP_VALUE_TYPE> retrieveGroup(int var1) throws IOException;

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        for (SearchGroupDocs<GROUP_VALUE_TYPE> group : this.groupMap.values()) {
            group.leafCollector = group.collector.getLeafCollector(readerContext);
        }
    }

    public TopGroups<GROUP_VALUE_TYPE> getTopGroups(int withinGroupOffset) {
        GroupDocs[] groupDocsResult = new GroupDocs[this.groups.size()];
        int groupIDX = 0;
        float maxScore = Float.MIN_VALUE;
        for (SearchGroup<GROUP_VALUE_TYPE> group : this.groups) {
            SearchGroupDocs<GROUP_VALUE_TYPE> groupDocs = this.groupMap.get(group.groupValue);
            TopDocs topDocs = groupDocs.collector.topDocs(withinGroupOffset, this.maxDocsPerGroup);
            groupDocsResult[groupIDX++] = new GroupDocs(Float.NaN, topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, groupDocs.groupValue, group.sortValues);
            maxScore = Math.max(maxScore, topDocs.getMaxScore());
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsResult, maxScore);
    }

    public class SearchGroupDocs<GROUP_VALUE_TYPE> {
        public final GROUP_VALUE_TYPE groupValue;
        public final TopDocsCollector<?> collector;
        public LeafCollector leafCollector;

        public SearchGroupDocs(GROUP_VALUE_TYPE groupValue, TopDocsCollector<?> collector) {
            this.groupValue = groupValue;
            this.collector = collector;
        }
    }
}

