/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.CharStream;
import org.apache.lucene.queryparser.classic.FastCharStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.classic.TokenMgrError;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;

public abstract class QueryParserBase
extends QueryBuilder
implements CommonQueryParserConfiguration {
    static final int CONJ_NONE = 0;
    static final int CONJ_AND = 1;
    static final int CONJ_OR = 2;
    static final int MOD_NONE = 0;
    static final int MOD_NOT = 10;
    static final int MOD_REQ = 11;
    public static final QueryParser.Operator AND_OPERATOR = QueryParser.Operator.AND;
    public static final QueryParser.Operator OR_OPERATOR = QueryParser.Operator.OR;
    QueryParser.Operator operator = OR_OPERATOR;
    boolean lowercaseExpandedTerms = true;
    MultiTermQuery.RewriteMethod multiTermRewriteMethod = MultiTermQuery.CONSTANT_SCORE_REWRITE;
    boolean allowLeadingWildcard = false;
    protected String field;
    int phraseSlop = 0;
    float fuzzyMinSim = 2.0f;
    int fuzzyPrefixLength = 0;
    Locale locale = Locale.getDefault();
    TimeZone timeZone = TimeZone.getDefault();
    DateTools.Resolution dateResolution = null;
    Map<String, DateTools.Resolution> fieldToDateResolution = null;
    boolean analyzeRangeTerms = false;
    boolean autoGeneratePhraseQueries;
    int maxDeterminizedStates = 10000;

    protected QueryParserBase() {
        super(null);
    }

    public void init(String f, Analyzer a) {
        this.setAnalyzer(a);
        this.field = f;
        this.setAutoGeneratePhraseQueries(false);
    }

    public abstract void ReInit(CharStream var1);

    public abstract Query TopLevelQuery(String var1) throws ParseException;

    public Query parse(String query) throws ParseException {
        this.ReInit(new FastCharStream(new StringReader(query)));
        try {
            Query res = this.TopLevelQuery(this.field);
            return res != null ? res : this.newBooleanQuery(false).build();
        }
        catch (ParseException | TokenMgrError tme) {
            ParseException e = new ParseException("Cannot parse '" + query + "': " + tme.getMessage());
            e.initCause(tme);
            throw e;
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            ParseException e = new ParseException("Cannot parse '" + query + "': too many boolean clauses");
            e.initCause(tmc);
            throw e;
        }
    }

    public String getField() {
        return this.field;
    }

    public final boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public final void setAutoGeneratePhraseQueries(boolean value) {
        this.autoGeneratePhraseQueries = value;
    }

    @Override
    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    @Override
    public void setFuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    @Override
    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Override
    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    @Override
    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    @Override
    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    @Override
    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    @Override
    public boolean getAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void setDefaultOperator(QueryParser.Operator op) {
        this.operator = op;
    }

    public QueryParser.Operator getDefaultOperator() {
        return this.operator;
    }

    @Override
    public void setLowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    @Override
    public boolean getLowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    @Override
    public void setMultiTermRewriteMethod(MultiTermQuery.RewriteMethod method) {
        this.multiTermRewriteMethod = method;
    }

    @Override
    public MultiTermQuery.RewriteMethod getMultiTermRewriteMethod() {
        return this.multiTermRewriteMethod;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setDateResolution(DateTools.Resolution dateResolution) {
        this.dateResolution = dateResolution;
    }

    public void setDateResolution(String fieldName, DateTools.Resolution dateResolution) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            this.fieldToDateResolution = new HashMap<String, DateTools.Resolution>();
        }
        this.fieldToDateResolution.put(fieldName, dateResolution);
    }

    public DateTools.Resolution getDateResolution(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            return this.dateResolution;
        }
        DateTools.Resolution resolution = this.fieldToDateResolution.get(fieldName);
        if (resolution == null) {
            resolution = this.dateResolution;
        }
        return resolution;
    }

    public void setAnalyzeRangeTerms(boolean analyzeRangeTerms) {
        this.analyzeRangeTerms = analyzeRangeTerms;
    }

    public boolean getAnalyzeRangeTerms() {
        return this.analyzeRangeTerms;
    }

    public void setMaxDeterminizedStates(int maxDeterminizedStates) {
        this.maxDeterminizedStates = maxDeterminizedStates;
    }

    public int getMaxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    protected void addClause(List<BooleanClause> clauses, int conj, int mods, Query q) {
        boolean required;
        boolean prohibited;
        BooleanClause c;
        if (clauses.size() > 0 && conj == 1 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            clauses.set(clauses.size() - 1, new BooleanClause(c.getQuery(), BooleanClause.Occur.MUST));
        }
        if (clauses.size() > 0 && this.operator == AND_OPERATOR && conj == 2 && !(c = clauses.get(clauses.size() - 1)).isProhibited()) {
            clauses.set(clauses.size() - 1, new BooleanClause(c.getQuery(), BooleanClause.Occur.SHOULD));
        }
        if (q == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            prohibited = mods == 10;
            boolean bl = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            boolean bl = required = !prohibited && conj != 2;
        }
        if (required && !prohibited) {
            clauses.add(this.newBooleanClause(q, BooleanClause.Occur.MUST));
        } else if (!required && !prohibited) {
            clauses.add(this.newBooleanClause(q, BooleanClause.Occur.SHOULD));
        } else if (!required && prohibited) {
            clauses.add(this.newBooleanClause(q, BooleanClause.Occur.MUST_NOT));
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        return this.newFieldQuery(this.getAnalyzer(), field, queryText, quoted);
    }

    protected Query newFieldQuery(Analyzer analyzer, String field, String queryText, boolean quoted) throws ParseException {
        BooleanClause.Occur occur = this.operator == QueryParser.Operator.AND ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
        return this.createFieldQuery(analyzer, occur, field, queryText, quoted || this.autoGeneratePhraseQueries, this.phraseSlop);
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Query query = this.getFieldQuery(field, queryText, true);
        if (query instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            PhraseQuery pq = (PhraseQuery)query;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            query = builder.build();
        }
        if (query instanceof MultiPhraseQuery) {
            ((MultiPhraseQuery)query).setSlop(slop);
        }
        return query;
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            part1 = part1 == null ? null : part1.toLowerCase(this.locale);
            part2 = part2 == null ? null : part2.toLowerCase(this.locale);
        }
        DateFormat df = DateFormat.getDateInstance(3, this.locale);
        df.setLenient(true);
        DateTools.Resolution resolution = this.getDateResolution(field);
        try {
            part1 = DateTools.dateToString(df.parse(part1), resolution);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Date d2 = df.parse(part2);
            if (endInclusive) {
                Calendar cal = Calendar.getInstance(this.timeZone, this.locale);
                cal.setTime(d2);
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                d2 = cal.getTime();
            }
            part2 = DateTools.dateToString(d2, resolution);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    protected BooleanClause newBooleanClause(Query q, BooleanClause.Occur occur) {
        return new BooleanClause(q, occur);
    }

    protected Query newPrefixQuery(Term prefix) {
        PrefixQuery query = new PrefixQuery(prefix);
        query.setRewriteMethod(this.multiTermRewriteMethod);
        return query;
    }

    protected Query newRegexpQuery(Term regexp) {
        RegexpQuery query = new RegexpQuery(regexp, 65535, this.maxDeterminizedStates);
        query.setRewriteMethod(this.multiTermRewriteMethod);
        return query;
    }

    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        String text = term.text();
        int numEdits = FuzzyQuery.floatToEdits(minimumSimilarity, text.codePointCount(0, text.length()));
        return new FuzzyQuery(term, numEdits, prefixLength);
    }

    private BytesRef analyzeMultitermTerm(String field, String part) {
        return this.analyzeMultitermTerm(field, part, this.getAnalyzer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BytesRef analyzeMultitermTerm(String field, String part, Analyzer analyzerIn) {
        if (analyzerIn == null) {
            analyzerIn = this.getAnalyzer();
        }
        try (TokenStream source = analyzerIn.tokenStream(field, part);){
            source.reset();
            TermToBytesRefAttribute termAtt = source.getAttribute(TermToBytesRefAttribute.class);
            if (!source.incrementToken()) {
                throw new IllegalArgumentException("analyzer returned no terms for multiTerm term: " + part);
            }
            BytesRef bytes = BytesRef.deepCopyOf(termAtt.getBytesRef());
            if (source.incrementToken()) {
                throw new IllegalArgumentException("analyzer returned too many terms for multiTerm term: " + part);
            }
            source.end();
            BytesRef bytesRef = bytes;
            return bytesRef;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing multiTerm term: " + part, e);
        }
    }

    protected Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        BytesRef start;
        if (part1 == null) {
            start = null;
        } else {
            BytesRef bytesRef = start = this.analyzeRangeTerms ? this.analyzeMultitermTerm(field, part1) : new BytesRef(part1);
        }
        BytesRef end = part2 == null ? null : (this.analyzeRangeTerms ? this.analyzeMultitermTerm(field, part2) : new BytesRef(part2));
        TermRangeQuery query = new TermRangeQuery(field, start, end, startInclusive, endInclusive);
        query.setRewriteMethod(this.multiTermRewriteMethod);
        return query;
    }

    protected Query newMatchAllDocsQuery() {
        return new MatchAllDocsQuery();
    }

    protected Query newWildcardQuery(Term t) {
        WildcardQuery query = new WildcardQuery(t, this.maxDeterminizedStates);
        query.setRewriteMethod(this.multiTermRewriteMethod);
        return query;
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws ParseException {
        return this.getBooleanQuery(clauses, false);
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        if (clauses.size() == 0) {
            return null;
        }
        BooleanQuery.Builder query = this.newBooleanQuery(disableCoord);
        for (BooleanClause clause : clauses) {
            query.add(clause);
        }
        return query.build();
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if ("*".equals(field) && "*".equals(termStr)) {
            return this.newMatchAllDocsQuery();
        }
        if (!this.allowLeadingWildcard && (termStr.startsWith("*") || termStr.startsWith("?"))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
        }
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        Term t = new Term(field, termStr);
        return this.newWildcardQuery(t);
    }

    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        Term t = new Term(field, termStr);
        return this.newRegexpQuery(t);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (!this.allowLeadingWildcard && termStr.startsWith("*")) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        Term t = new Term(field, termStr);
        return this.newPrefixQuery(t);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase(this.locale);
        }
        Term t = new Term(field, termStr);
        return this.newFuzzyQuery(t, minSimilarity, this.fuzzyPrefixLength);
    }

    Query handleBareTokenQuery(String qfield, Token term, Token fuzzySlop, boolean prefix, boolean wildcard, boolean fuzzy, boolean regexp) throws ParseException {
        String termImage = this.discardEscapeChar(term.image);
        Query q = wildcard ? this.getWildcardQuery(qfield, term.image) : (prefix ? this.getPrefixQuery(qfield, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1))) : (regexp ? this.getRegexpQuery(qfield, term.image.substring(1, term.image.length() - 1)) : (fuzzy ? this.handleBareFuzzy(qfield, fuzzySlop, termImage) : this.getFieldQuery(qfield, termImage, false))));
        return q;
    }

    Query handleBareFuzzy(String qfield, Token fuzzySlop, String termImage) throws ParseException {
        float fms = this.fuzzyMinSim;
        try {
            fms = Float.valueOf(fuzzySlop.image.substring(1)).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fms < 0.0f) {
            throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
        }
        if (fms >= 1.0f && fms != (float)((int)fms)) {
            throw new ParseException("Fractional edit distances are not allowed!");
        }
        Query q = this.getFuzzyQuery(qfield, termImage, fms);
        return q;
    }

    Query handleQuotedTerm(String qfield, Token term, Token fuzzySlop) throws ParseException {
        int s = this.phraseSlop;
        if (fuzzySlop != null) {
            try {
                s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getFieldQuery(qfield, this.discardEscapeChar(term.image.substring(1, term.image.length() - 1)), s);
    }

    Query handleBoost(Query q, Token boost) {
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (q != null) {
                q = new BoostQuery(q, f);
            }
        }
        return q;
    }

    String discardEscapeChar(String input) throws ParseException {
        char[] output = new char[input.length()];
        int length = 0;
        boolean lastCharWasEscapeChar = false;
        int codePointMultiplier = 0;
        int codePoint = 0;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (codePointMultiplier > 0) {
                codePoint += QueryParserBase.hexToInt(curChar) * codePointMultiplier;
                if ((codePointMultiplier >>>= 4) != 0) continue;
                output[length++] = (char)codePoint;
                codePoint = 0;
                continue;
            }
            if (lastCharWasEscapeChar) {
                if (curChar == 'u') {
                    codePointMultiplier = 4096;
                } else {
                    output[length] = curChar;
                    ++length;
                }
                lastCharWasEscapeChar = false;
                continue;
            }
            if (curChar == '\\') {
                lastCharWasEscapeChar = true;
                continue;
            }
            output[length] = curChar;
            ++length;
        }
        if (codePointMultiplier > 0) {
            throw new ParseException("Truncated unicode escape sequence.");
        }
        if (lastCharWasEscapeChar) {
            throw new ParseException("Term can not end with escape character.");
        }
        return new String(output, 0, length);
    }

    static final int hexToInt(char c) throws ParseException {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new ParseException("Non-hex character in Unicode escape sequence: " + c);
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static class MethodRemovedUseAnother
    extends Throwable {
    }
}

