/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.markdown;

import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.markdown.FlexmarkParser;
import org.apache.zeppelin.markdown.Markdown4jParser;
import org.apache.zeppelin.markdown.MarkdownParser;
import org.apache.zeppelin.markdown.PegdownParser;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Markdown
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Markdown.class);
    private MarkdownParser parser;
    public static final String MARKDOWN_PARSER_TYPE = "markdown.parser.type";
    public static final String PARSER_TYPE_PEGDOWN = "pegdown";
    public static final String PARSER_TYPE_MARKDOWN4J = "markdown4j";
    public static final String PARSER_TYPE_FLEXMARK = "flexmark";

    public Markdown(Properties property) {
        super(property);
    }

    public static MarkdownParser createMarkdownParser(String parserType) {
        LOGGER.debug("Creating {} markdown interpreter", (Object)parserType);
        if (MarkdownParserType.PEGDOWN.toString().equals(parserType)) {
            return new PegdownParser();
        }
        if (MarkdownParserType.FLEXMARK.toString().equals(parserType)) {
            return new FlexmarkParser();
        }
        return new Markdown4jParser();
    }

    public void open() {
        String parserType = this.getProperty(MARKDOWN_PARSER_TYPE);
        this.parser = Markdown.createMarkdownParser(parserType);
    }

    public void close() {
    }

    public InterpreterResult interpret(String markdownText, InterpreterContext interpreterContext) {
        String html;
        try {
            html = this.parser.render(markdownText);
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception in MarkdownInterpreter while interpret ", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage((Exception)e));
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, "%html " + html);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetParallelScheduler(Markdown.class.getName() + ((Object)((Object)this)).hashCode(), 5);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return null;
    }

    public static enum MarkdownParserType {
        PEGDOWN{

            public String toString() {
                return Markdown.PARSER_TYPE_PEGDOWN;
            }
        }
        ,
        MARKDOWN4j{

            public String toString() {
                return Markdown.PARSER_TYPE_MARKDOWN4J;
            }
        }
        ,
        FLEXMARK{

            public String toString() {
                return Markdown.PARSER_TYPE_FLEXMARK;
            }
        };

    }
}

