/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MacroDefinitionRepository
extends NodeRepository<MacroDefinitionBlock> {
    private ArrayList<MacroDefinitionBlock> myReferencedMacroDefinitionBlocks = new ArrayList();

    public void addMacrosReference(MacroDefinitionBlock macroDefinitionBlock, MacroReference macros) {
        if (!macroDefinitionBlock.isReferenced()) {
            this.myReferencedMacroDefinitionBlocks.add(macroDefinitionBlock);
        }
        macroDefinitionBlock.setFirstReferenceOffset(macros.getStartOffset());
    }

    public void resolveMacrosOrdinals() {
        Collections.sort(this.myReferencedMacroDefinitionBlocks, new MacroDefinitionBlockComparator());
        int ordinal = 0;
        for (MacroDefinitionBlock macroDefinitionBlock : this.myReferencedMacroDefinitionBlocks) {
            macroDefinitionBlock.setOrdinal(++ordinal);
        }
    }

    public List<MacroDefinitionBlock> getReferencedMacroDefinitionBlocks() {
        return this.myReferencedMacroDefinitionBlocks;
    }

    public MacroDefinitionRepository(DataHolder options) {
        super(MacrosExtension.MACRO_DEFINITIONS_KEEP.getFrom(options));
    }

    @Override
    public DataKey<MacroDefinitionRepository> getDataKey() {
        return MacrosExtension.MACRO_DEFINITIONS;
    }

    @Override
    public DataKey<KeepType> getKeepDataKey() {
        return MacrosExtension.MACRO_DEFINITIONS_KEEP;
    }

    @Override
    public Set<MacroDefinitionBlock> getReferencedElements(Node parent) {
        HashSet<MacroDefinitionBlock> references = new HashSet<MacroDefinitionBlock>();
        this.visitNodes(parent, value -> {
            MacroDefinitionBlock reference;
            if (value instanceof MacroReference && (reference = ((MacroReference)value).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, MacroReference.class);
        return references;
    }

    private static class MacroDefinitionBlockComparator
    implements Comparator<MacroDefinitionBlock> {
        private MacroDefinitionBlockComparator() {
        }

        @Override
        public int compare(MacroDefinitionBlock f1, MacroDefinitionBlock f2) {
            return Integer.compare(f1.getFirstReferenceOffset(), f2.getFirstReferenceOffset());
        }
    }
}

