/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros;

import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferencingNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class MacroReference
extends Node
implements DelimitedNode,
DoNotDecorate,
ReferencingNode<MacroDefinitionRepository, MacroDefinitionBlock> {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected MacroDefinitionBlock myMacroDefinitionBlock;

    @Override
    public boolean isDefined() {
        return this.myMacroDefinitionBlock != null;
    }

    @Override
    public BasedSequence getReference() {
        return this.text;
    }

    @Override
    public MacroDefinitionBlock getReferenceNode(Document document) {
        if (this.myMacroDefinitionBlock != null || this.text.isEmpty()) {
            return this.myMacroDefinitionBlock;
        }
        this.myMacroDefinitionBlock = this.getMacroDefinitionBlock(document.get(MacrosExtension.MACRO_DEFINITIONS));
        return this.myMacroDefinitionBlock;
    }

    @Override
    public MacroDefinitionBlock getReferenceNode(MacroDefinitionRepository repository) {
        if (this.myMacroDefinitionBlock != null || this.text.isEmpty()) {
            return this.myMacroDefinitionBlock;
        }
        this.myMacroDefinitionBlock = this.getMacroDefinitionBlock(repository);
        return this.myMacroDefinitionBlock;
    }

    public MacroDefinitionBlock getMacroDefinitionBlock(MacroDefinitionRepository repository) {
        return this.text.isEmpty() ? null : (MacroDefinitionBlock)repository.get(this.text.toString());
    }

    public MacroDefinitionBlock getMacroDefinitionBlock() {
        return this.myMacroDefinitionBlock;
    }

    public void setMacroDefinitionBlock(MacroDefinitionBlock macroDefinitionBlock) {
        this.myMacroDefinitionBlock = macroDefinitionBlock;
    }

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        MacroReference.delimitedSegmentSpanChars(out, this.openingMarker, this.text, this.closingMarker, "text");
    }

    public MacroReference() {
    }

    public MacroReference(BasedSequence chars) {
        super(chars);
    }

    public MacroReference(BasedSequence openingMarker, BasedSequence text, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.text = text;
        this.closingMarker = closingMarker;
    }

    @Override
    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    @Override
    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    @Override
    public BasedSequence getText() {
        return this.text;
    }

    @Override
    public void setText(BasedSequence text) {
        this.text = text;
    }

    @Override
    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    @Override
    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

