/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.aside.internal;

import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.aside.AsideBlock;
import com.vladsch.flexmark.ext.aside.AsideExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AsideBlockParser
extends AbstractBlockParser {
    public static final char MARKER_CHAR = '|';
    private final AsideBlock block = new AsideBlock();
    private final boolean allowLeadingSpace;
    private final boolean continueToBlankLine;
    private final boolean ignoreBlankLine;
    private final boolean interruptsParagraph;
    private final boolean interruptsItemParagraph;
    private final boolean withLeadSpacesInterruptsItemParagraph;
    private int lastWasBlankLine = 0;

    public AsideBlockParser(DataHolder options, BasedSequence marker) {
        this.block.setOpeningMarker(marker);
        this.continueToBlankLine = options.get(AsideExtension.EXTEND_TO_BLANK_LINE);
        this.allowLeadingSpace = options.get(AsideExtension.ALLOW_LEADING_SPACE);
        this.ignoreBlankLine = options.get(AsideExtension.IGNORE_BLANK_LINE);
        this.interruptsParagraph = options.get(AsideExtension.INTERRUPTS_PARAGRAPH);
        this.interruptsItemParagraph = options.get(AsideExtension.INTERRUPTS_ITEM_PARAGRAPH);
        this.withLeadSpacesInterruptsItemParagraph = options.get(AsideExtension.WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    @Override
    public AsideBlock getBlock() {
        return this.block;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
        if (!state.getProperties().get(Parser.BLANK_LINES_IN_AST).booleanValue()) {
            this.removeBlankLines();
        }
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        boolean isMarker;
        int nextNonSpace = state.getNextNonSpaceIndex();
        if (!state.isBlank() && ((isMarker = AsideBlockParser.isMarker(state, nextNonSpace, false, false, this.allowLeadingSpace, this.interruptsParagraph, this.interruptsItemParagraph, this.withLeadSpacesInterruptsItemParagraph)) || this.continueToBlankLine && this.lastWasBlankLine == 0)) {
            int newColumn = state.getColumn() + state.getIndent();
            this.lastWasBlankLine = 0;
            if (isMarker) {
                ++newColumn;
                if (Parsing.isSpaceOrTab(state.getLine(), nextNonSpace + 1)) {
                    ++newColumn;
                }
            }
            return BlockContinue.atColumn(newColumn);
        }
        if (this.ignoreBlankLine && state.isBlank()) {
            ++this.lastWasBlankLine;
            int newColumn = state.getColumn() + state.getIndent();
            return BlockContinue.atColumn(newColumn);
        }
        return BlockContinue.none();
    }

    static boolean isMarker(ParserState state, int index, boolean inParagraph, boolean inParagraphListItem, boolean allowLeadingSpace, boolean interruptsParagraph, boolean interruptsItemParagraph, boolean withLeadSpacesInterruptsItemParagraph) {
        BasedSequence line = state.getLine();
        if (!(inParagraph && !interruptsParagraph || index >= line.length() || line.charAt(index) != '|' || !allowLeadingSpace && state.getIndent() != 0 || inParagraphListItem && !interruptsItemParagraph)) {
            if (inParagraphListItem && !withLeadSpacesInterruptsItemParagraph) {
                return state.getIndent() == 0;
            }
            return state.getIndent() < state.getParsing().CODE_BLOCK_INDENT;
        }
        return false;
    }

    static boolean endsWithMarker(BasedSequence line) {
        int tailBlanks = line.countTrailing(" \t\r\n\u00a0");
        return tailBlanks + 1 < line.length() && line.charAt(line.length() - tailBlanks - 1) == '|';
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final boolean allowLeadingSpace;
        private final boolean interruptsParagraph;
        private final boolean interruptsItemParagraph;
        private final boolean withLeadSpacesInterruptsItemParagraph;

        BlockFactory(DataHolder options) {
            super(options);
            this.allowLeadingSpace = AsideExtension.ALLOW_LEADING_SPACE.getFrom(options);
            this.interruptsParagraph = AsideExtension.INTERRUPTS_PARAGRAPH.getFrom(options);
            this.interruptsItemParagraph = AsideExtension.INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.withLeadSpacesInterruptsItemParagraph = AsideExtension.WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            boolean inParagraphListItem;
            int nextNonSpace = state.getNextNonSpaceIndex();
            BlockParser matched = matchedBlockParser.getBlockParser();
            boolean inParagraph = matched.isParagraphParser();
            boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
            if (!AsideBlockParser.endsWithMarker(state.getLine()) && AsideBlockParser.isMarker(state, nextNonSpace, inParagraph, inParagraphListItem, this.allowLeadingSpace, this.interruptsParagraph, this.interruptsItemParagraph, this.withLeadSpacesInterruptsItemParagraph)) {
                int newColumn = state.getColumn() + state.getIndent() + 1;
                if (Parsing.isSpaceOrTab(state.getLine(), nextNonSpace + 1)) {
                    ++newColumn;
                }
                return BlockStart.of(new AsideBlockParser(state.getProperties(), (BasedSequence)state.getLine().subSequence(nextNonSpace, nextNonSpace + 1))).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            HashSet<Class<? extends CustomBlockParserFactory>> set = new HashSet<Class<? extends CustomBlockParserFactory>>();
            return set;
        }

        @Override
        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory apply(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

