/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public abstract class LinkNodeBase
extends Node {
    protected BasedSequence urlOpeningMarker = BasedSequence.NULL;
    protected BasedSequence url = BasedSequence.NULL;
    protected BasedSequence pageRef = BasedSequence.NULL;
    protected BasedSequence anchorMarker = BasedSequence.NULL;
    protected BasedSequence anchorRef = BasedSequence.NULL;
    protected BasedSequence urlClosingMarker = BasedSequence.NULL;
    protected BasedSequence titleOpeningMarker = BasedSequence.NULL;
    protected BasedSequence title = BasedSequence.NULL;
    protected BasedSequence titleClosingMarker = BasedSequence.NULL;

    public LinkNodeBase() {
    }

    public LinkNodeBase(BasedSequence chars) {
        super(chars);
    }

    public void setTitleChars(BasedSequence titleChars) {
        if (titleChars != null && titleChars != BasedSequence.NULL) {
            int titleCharsLength = titleChars.length();
            this.titleOpeningMarker = (BasedSequence)titleChars.subSequence(0, 1);
            this.title = (BasedSequence)titleChars.subSequence(1, titleCharsLength - 1);
            this.titleClosingMarker = (BasedSequence)titleChars.subSequence(titleCharsLength - 1, titleCharsLength);
        } else {
            this.titleOpeningMarker = BasedSequence.NULL;
            this.title = BasedSequence.NULL;
            this.titleClosingMarker = BasedSequence.NULL;
        }
    }

    public void setUrlChars(BasedSequence url) {
        if (url != null && url != BasedSequence.NULL) {
            if (url.startsWith("<") && url.endsWith(">")) {
                this.urlOpeningMarker = (BasedSequence)url.subSequence(0, 1);
                this.url = (BasedSequence)url.subSequence(1, url.length() - 1);
                this.urlClosingMarker = (BasedSequence)url.subSequence(url.length() - 1);
            } else {
                this.url = url;
            }
            int pos = this.url.indexOf('#');
            if (pos < 0) {
                this.pageRef = this.url;
            } else {
                this.pageRef = (BasedSequence)this.url.subSequence(0, pos);
                this.anchorMarker = (BasedSequence)this.url.subSequence(pos, pos + 1);
                this.anchorRef = (BasedSequence)this.url.subSequence(pos + 1);
            }
        } else {
            this.urlOpeningMarker = BasedSequence.NULL;
            this.url = BasedSequence.NULL;
            this.urlClosingMarker = BasedSequence.NULL;
        }
    }

    public BasedSequence getPageRef() {
        return this.pageRef;
    }

    public void setPageRef(BasedSequence pageRef) {
        this.pageRef = pageRef;
    }

    public BasedSequence getAnchorMarker() {
        return this.anchorMarker;
    }

    public void setAnchorMarker(BasedSequence anchorMarker) {
        this.anchorMarker = anchorMarker;
    }

    public BasedSequence getAnchorRef() {
        return this.anchorRef;
    }

    public void setAnchorRef(BasedSequence anchorRef) {
        this.anchorRef = anchorRef;
    }

    public BasedSequence getUrl() {
        return this.url;
    }

    public BasedSequence getTitle() {
        return this.title;
    }

    public BasedSequence getUrlOpeningMarker() {
        return this.urlOpeningMarker;
    }

    public void setUrlOpeningMarker(BasedSequence urlOpeningMarker) {
        this.urlOpeningMarker = urlOpeningMarker;
    }

    public void setUrl(BasedSequence url) {
        this.url = url;
    }

    public BasedSequence getUrlClosingMarker() {
        return this.urlClosingMarker;
    }

    public void setUrlClosingMarker(BasedSequence urlClosingMarker) {
        this.urlClosingMarker = urlClosingMarker;
    }

    public BasedSequence getTitleOpeningMarker() {
        return this.titleOpeningMarker;
    }

    public void setTitleOpeningMarker(BasedSequence titleOpeningMarker) {
        this.titleOpeningMarker = titleOpeningMarker;
    }

    public void setTitle(BasedSequence title) {
        this.title = title;
    }

    public BasedSequence getTitleClosingMarker() {
        return this.titleClosingMarker;
    }

    public void setTitleClosingMarker(BasedSequence titleClosingMarker) {
        this.titleClosingMarker = titleClosingMarker;
    }
}

