/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.CombineGroupsP;
import com.hazelcast.jet.stream.impl.processor.GroupAndAccumulateP;
import java.util.stream.Collector;

public class GroupingSinkReducer<T, A, K, D, R>
implements DistributedCollector.Reducer<T, R> {
    private final String sinkName;
    private final DistributedFunction<JetInstance, ? extends R> toDistributedObject;
    private final DistributedFunction<? super T, ? extends K> classifier;
    private final Collector<? super T, A, D> collector;
    private final ProcessorMetaSupplier metaSupplier;

    public GroupingSinkReducer(String sinkName, DistributedFunction<JetInstance, ? extends R> toDistributedObject, DistributedFunction<? super T, ? extends K> classifier, Collector<? super T, A, D> collector, ProcessorMetaSupplier metaSupplier) {
        this.sinkName = sinkName;
        this.toDistributedObject = toDistributedObject;
        this.classifier = classifier;
        this.collector = collector;
        this.metaSupplier = metaSupplier;
    }

    @Override
    public R reduce(StreamContext context, Pipe<? extends T> upstream) {
        DAG dag = new DAG();
        Vertex previous = upstream.buildDAG(dag);
        Vertex merger = dag.newVertex("group-and-accumulate", () -> new GroupAndAccumulateP(this.classifier, this.collector));
        Vertex combiner = dag.newVertex("combine-groups", () -> new CombineGroupsP(this.collector));
        Vertex writer = dag.newVertex(this.sinkName, this.metaSupplier);
        dag.edge(Edge.between(previous, merger).partitioned(this.classifier::apply, Partitioner.HASH_CODE)).edge(Edge.between(merger, combiner).distributed().partitioned(DistributedFunctions.entryKey())).edge(Edge.between(combiner, writer));
        StreamUtil.executeJob(context, dag);
        return this.toDistributedObject.apply(context.getJetInstance());
    }
}

