/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.AbstractProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class CombineGroupsP<K, V, A, R>
extends AbstractProcessor {
    private final Map<K, A> groups = new HashMap<K, A>();
    private final Collector<V, A, R> collector;
    private final Traverser<Map.Entry<K, R>> resultTraverser;

    public CombineGroupsP(Collector<V, A, R> collector) {
        this.collector = collector;
        this.resultTraverser = Traversers.lazy(() -> Traversers.traverseStream(this.groups.entrySet().stream().map(item -> Util.entry(item.getKey(), collector.finisher().apply(item.getValue())))));
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        Map.Entry entry = (Map.Entry)item;
        Object value = this.groups.computeIfAbsent(entry.getKey(), k -> this.collector.supplier().get());
        this.collector.combiner().apply(value, entry.getValue());
        return true;
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.resultTraverser);
    }
}

