/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.function.DistributedFunction;
import java.io.Serializable;
import java.util.Map;

public final class JoinClause<K, T0, T1, T1_OUT>
implements Serializable {
    private final DistributedFunction<? super T0, ? extends K> leftKeyFn;
    private final DistributedFunction<? super T1, ? extends K> rightKeyFn;
    private final DistributedFunction<? super T1, ? extends T1_OUT> rightProjectFn;

    private JoinClause(DistributedFunction<? super T0, ? extends K> leftKeyFn, DistributedFunction<? super T1, ? extends K> rightKeyFn, DistributedFunction<? super T1, ? extends T1_OUT> rightProjectFn) {
        this.leftKeyFn = leftKeyFn;
        this.rightKeyFn = rightKeyFn;
        this.rightProjectFn = rightProjectFn;
    }

    public static <K, T0, T1> JoinClause<K, T0, T1, T1> onKeys(DistributedFunction<? super T0, ? extends K> leftKeyFn, DistributedFunction<? super T1, ? extends K> rightKeyFn) {
        return new JoinClause(leftKeyFn, rightKeyFn, DistributedFunction.identity());
    }

    public static <K, T0, T1_OUT> JoinClause<K, T0, Map.Entry<K, T1_OUT>, T1_OUT> joinMapEntries(DistributedFunction<? super T0, ? extends K> leftKeyFn) {
        return new JoinClause(leftKeyFn, Map.Entry::getKey, Map.Entry::getValue);
    }

    public <T1_NEW_OUT> JoinClause<K, T0, T1, T1_NEW_OUT> projecting(DistributedFunction<? super T1, ? extends T1_NEW_OUT> rightProjectFn) {
        return new JoinClause<K, T0, T1, T1_NEW_OUT>(this.leftKeyFn, this.rightKeyFn, rightProjectFn);
    }

    public DistributedFunction<? super T0, ? extends K> leftKeyFn() {
        return this.leftKeyFn;
    }

    public DistributedFunction<? super T1, ? extends K> rightKeyFn() {
        return this.rightKeyFn;
    }

    public DistributedFunction<? super T1, ? extends T1_OUT> rightProjectFn() {
        return this.rightProjectFn;
    }
}

