/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.WatermarkGenerationParams;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.StreamSource;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamSourceTransform<T>
extends AbstractTransform
implements StreamSource<T> {
    private final Function<WatermarkGenerationParams<T>, ProcessorMetaSupplier> metaSupplierFn;
    private final boolean supportsWatermarks;
    @Nullable
    private WatermarkGenerationParams<T> wmParams;

    public StreamSourceTransform(@Nonnull String name, @Nonnull Function<WatermarkGenerationParams<T>, ProcessorMetaSupplier> metaSupplierFn, boolean supportsWatermarks) {
        super(name, Collections.emptyList());
        this.metaSupplierFn = metaSupplierFn;
        this.supportsWatermarks = supportsWatermarks;
    }

    @Override
    public void addToDag(Planner p) {
        WatermarkGenerationParams params;
        WatermarkGenerationParams watermarkGenerationParams = params = this.emitsJetEvents() ? this.wmParams : WatermarkGenerationParams.noWatermarks();
        if (this.supportsWatermarks || !this.emitsJetEvents()) {
            p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), this.metaSupplierFn.apply(params));
        } else {
            String v1name = p.uniqueVertexName(this.name(), "");
            Vertex v1 = p.dag.newVertex(v1name, this.metaSupplierFn.apply(params)).localParallelism(this.localParallelism());
            Planner.PlannerVertex pv2 = p.addVertex((Transform)this, v1name + "-insertWM", this.localParallelism(), Processors.insertWatermarksP(params));
            p.dag.edge(Edge.between(v1, pv2.v).isolated());
        }
    }

    @Nullable
    public WatermarkGenerationParams<T> getWmParams() {
        return this.wmParams;
    }

    public void setWmGenerationParams(WatermarkGenerationParams<T> wmParams) {
        this.wmParams = wmParams;
    }

    public boolean emitsJetEvents() {
        return this.wmParams != null;
    }
}

