/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import java.util.List;
import javax.annotation.Nonnull;

public class SinkTransform<T>
extends AbstractTransform {
    private static final int[] EMPTY_ORDINALS = new int[0];
    @Nonnull
    private ProcessorMetaSupplier metaSupplier;
    @Nonnull
    private final int[] ordinalsToAdapt;

    public SinkTransform(@Nonnull SinkImpl sink, @Nonnull List<Transform> upstream, @Nonnull int[] ordinalsToAdapt) {
        super(sink.name(), upstream);
        this.metaSupplier = sink.metaSupplier();
        this.ordinalsToAdapt = ordinalsToAdapt;
    }

    public SinkTransform(@Nonnull SinkImpl sink, @Nonnull Transform upstream, boolean adaptToJetEvents) {
        super(sink.name(), upstream);
        int[] nArray;
        this.metaSupplier = sink.metaSupplier();
        if (adaptToJetEvents) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = EMPTY_ORDINALS;
        }
        this.ordinalsToAdapt = nArray;
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), FunctionAdapter.adaptingMetaSupplier(this.metaSupplier, this.ordinalsToAdapt));
        p.addEdges(this, pv.v);
    }
}

