/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.datamodel.TimestampedEntry;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.JetEventFunctionAdapter;
import com.hazelcast.jet.impl.pipeline.StageWithGroupingBase;
import com.hazelcast.jet.impl.pipeline.StreamStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.WindowGroupTransform;
import com.hazelcast.jet.pipeline.StageWithGroupingAndWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.StreamStageWithGrouping;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StageWithGroupingAndWindowImpl<T, K>
extends StageWithGroupingBase<T, K>
implements StageWithGroupingAndWindow<T, K> {
    @Nonnull
    private final WindowDefinition wDef;

    StageWithGroupingAndWindowImpl(@Nonnull StreamStageImpl<T> computeStage, @Nonnull DistributedFunction<? super T, ? extends K> keyFn, @Nonnull WindowDefinition wDef) {
        super(computeStage, keyFn);
        this.wDef = wDef;
    }

    @Override
    @Nonnull
    public WindowDefinition windowDefinition() {
        return this.wDef;
    }

    @Override
    @Nonnull
    public <A, R, OUT> StreamStage<OUT> aggregate(@Nonnull AggregateOperation1<? super T, A, R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, OUT> mapToOutputFn) {
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform(Collections.singletonList(this.computeStage.transform), this.wDef, Collections.singletonList(JetEventFunctionAdapter.adaptKeyFn(this.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation1(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn)), fnAdapter);
    }

    @Override
    @Nonnull
    public <A, R> StreamStage<TimestampedEntry<K, R>> aggregate(@Nonnull AggregateOperation1<? super T, A, R> aggrOp) {
        return this.aggregate(aggrOp, TimestampedEntry::new);
    }

    @Override
    @Nonnull
    public <T1, A, R, OUT> StreamStage<OUT> aggregate2(@Nonnull StreamStageWithGrouping<T1, ? extends K> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, A, R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, OUT> mapToOutputFn) {
        ComputeStageImplBase stageImpl1 = ((StageWithGroupingBase)((Object)stage1)).computeStage;
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(stageImpl1, "stage1");
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform(Arrays.asList(this.computeStage.transform, stageImpl1.transform), this.wDef, Arrays.asList(JetEventFunctionAdapter.adaptKeyFn(this.keyFn()), JetEventFunctionAdapter.adaptKeyFn(stage1.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation2(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, A, R> StreamStage<TimestampedEntry<K, R>> aggregate2(@Nonnull StreamStageWithGrouping<T1, ? extends K> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, A, R> aggrOp) {
        return this.aggregate2(stage1, aggrOp, TimestampedEntry::new);
    }

    @Override
    @Nonnull
    public <T1, T2, A, R, OUT> StreamStage<OUT> aggregate3(@Nonnull StreamStageWithGrouping<T1, ? extends K> stage1, @Nonnull StreamStageWithGrouping<T2, ? extends K> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, A, R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, OUT> mapToOutputFn) {
        ComputeStageImplBase stageImpl1 = ((StageWithGroupingBase)((Object)stage1)).computeStage;
        ComputeStageImplBase stageImpl2 = ((StageWithGroupingBase)((Object)stage2)).computeStage;
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(stageImpl1, "stage1");
        ComputeStageImplBase.ensureJetEvents(stageImpl2, "stage2");
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform(Arrays.asList(this.computeStage.transform, stageImpl1.transform, stageImpl2.transform), this.wDef, Arrays.asList(JetEventFunctionAdapter.adaptKeyFn(this.keyFn()), JetEventFunctionAdapter.adaptKeyFn(stage1.keyFn()), JetEventFunctionAdapter.adaptKeyFn(stage2.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation3(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, T2, A, R> StreamStage<TimestampedEntry<K, R>> aggregate3(@Nonnull StreamStageWithGrouping<T1, ? extends K> stage1, @Nonnull StreamStageWithGrouping<T2, ? extends K> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, A, R> aggrOp) {
        return this.aggregate3(stage1, stage2, aggrOp, TimestampedEntry::new);
    }
}

