/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.function.DistributedFunctions;
import com.hazelcast.jet.impl.ExplodeSnapshotP;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.SnapshotRepository;
import com.hazelcast.jet.impl.exception.JobRestartRequestedException;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.execution.init.ExecutionPlanBuilder;
import com.hazelcast.jet.impl.operation.CancelExecutionOperation;
import com.hazelcast.jet.impl.operation.CompleteExecutionOperation;
import com.hazelcast.jet.impl.operation.InitExecutionOperation;
import com.hazelcast.jet.impl.operation.SnapshotOperation;
import com.hazelcast.jet.impl.operation.StartExecutionOperation;
import com.hazelcast.jet.impl.util.CompletionToken;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.NonCompletableFuture;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MasterContext {
    public static final int SNAPSHOT_RESTORE_EDGE_PRIORITY = Integer.MIN_VALUE;
    private final NodeEngineImpl nodeEngine;
    private final JobCoordinationService coordinationService;
    private final ILogger logger;
    private final JobRecord jobRecord;
    private final long jobId;
    private final NonCompletableFuture completionFuture = new NonCompletableFuture();
    private final CompletionToken cancellationToken;
    private final AtomicReference<JobStatus> jobStatus = new AtomicReference<JobStatus>(JobStatus.NOT_STARTED);
    private final SnapshotRepository snapshotRepository;
    private volatile Set<Vertex> vertices;
    private volatile long executionId;
    private volatile long jobStartTime;
    private volatile Map<MemberInfo, ExecutionPlan> executionPlanMap;
    private volatile CompletionToken executionRestartToken;

    MasterContext(NodeEngineImpl nodeEngine, JobCoordinationService coordinationService, JobRecord jobRecord) {
        this.nodeEngine = nodeEngine;
        this.coordinationService = coordinationService;
        this.snapshotRepository = coordinationService.snapshotRepository();
        this.logger = nodeEngine.getLogger(this.getClass());
        this.jobRecord = jobRecord;
        this.jobId = jobRecord.getJobId();
        this.cancellationToken = new CompletionToken(this.logger);
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public JobStatus jobStatus() {
        return this.jobStatus.get();
    }

    public JobConfig getJobConfig() {
        return this.jobRecord.getConfig();
    }

    public JobRecord getJobRecord() {
        return this.jobRecord;
    }

    public CompletableFuture<Void> completionFuture() {
        return this.completionFuture;
    }

    boolean cancelJob() {
        return this.cancellationToken.complete();
    }

    boolean isCancelled() {
        return this.cancellationToken.isCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryStartJob(Function<Long, Long> executionIdSupplier) {
        DAG dag;
        if (!this.setJobStatusToStarting()) {
            return;
        }
        if (this.scheduleRestartIfQuorumAbsent() || this.scheduleRestartIfClusterIsNotSafe()) {
            return;
        }
        try {
            dag = this.deserializeDAG();
        }
        catch (Exception e) {
            this.logger.warning("DAG deserialization failed", e);
            this.finalizeJob(e);
            return;
        }
        this.vertices = new HashSet<Vertex>();
        dag.iterator().forEachRemaining(this.vertices::add);
        this.executionId = executionIdSupplier.apply(this.jobId);
        long lastSnapshotId = -1L;
        if (this.isSnapshottingEnabled()) {
            Long snapshotIdToRestore = this.snapshotRepository.latestCompleteSnapshot(this.jobId);
            this.snapshotRepository.deleteAllSnapshotsExceptOne(this.jobId, snapshotIdToRestore);
            Long lastStartedSnapshot = this.snapshotRepository.latestStartedSnapshot(this.jobId);
            if (snapshotIdToRestore != null) {
                this.logger.info("State of " + this.jobIdString() + " will be restored from snapshot " + snapshotIdToRestore);
                this.rewriteDagWithSnapshotRestore(dag, snapshotIdToRestore);
            } else {
                this.logger.info("No previous snapshot for " + this.jobIdString() + " found.");
            }
            if (lastStartedSnapshot != null) {
                lastSnapshotId = lastStartedSnapshot;
            }
        }
        MembersView membersView = this.getMembersView();
        ClassLoader previousCL = MasterContext.swapContextClassLoader(this.coordinationService.getClassLoader(this.jobId));
        try {
            int defaultLocalParallelism = Util.getJetInstance(this.nodeEngine).getConfig().getInstanceConfig().getCooperativeThreadCount();
            this.logger.info("Start executing " + this.jobIdString() + ", status " + (Object)((Object)this.jobStatus()) + "\n" + dag.toString(defaultLocalParallelism));
            this.logger.fine("Building execution plan for " + this.jobIdString());
            this.executionPlanMap = ExecutionPlanBuilder.createExecutionPlans(this.nodeEngine, membersView, dag, this.getJobConfig(), lastSnapshotId);
        }
        catch (Exception e) {
            this.logger.severe("Exception creating execution plan for " + this.jobIdString(), e);
            this.finalizeJob(e);
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousCL);
        }
        this.logger.fine("Built execution plans for " + this.jobIdString());
        Set<MemberInfo> participants = this.executionPlanMap.keySet();
        Function<ExecutionPlan, Operation> operationCtor = plan -> new InitExecutionOperation(this.jobId, this.executionId, membersView.getVersion(), participants, (Data)this.nodeEngine.getSerializationService().toData(plan));
        this.invoke(operationCtor, this::onInitStepCompleted, null);
    }

    private void rewriteDagWithSnapshotRestore(DAG dag, long snapshotId) {
        this.logger.info(this.jobIdString() + ": restoring state from snapshotId=" + snapshotId);
        for (Vertex vertex : dag) {
            String mapName = SnapshotRepository.snapshotDataMapName(this.jobId, snapshotId, vertex.getName());
            Vertex readSnapshotVertex = dag.newVertex("__snapshot_read." + vertex.getName(), SourceProcessors.readMapP(mapName));
            Vertex explodeVertex = dag.newVertex("__snapshot_explode." + vertex.getName(), ExplodeSnapshotP::new);
            readSnapshotVertex.localParallelism(vertex.getLocalParallelism());
            explodeVertex.localParallelism(vertex.getLocalParallelism());
            int destOrdinal = dag.getInboundEdges(vertex.getName()).size();
            dag.edge(Edge.between(readSnapshotVertex, explodeVertex).isolated()).edge(new SnapshotRestoreEdge(explodeVertex, vertex, destOrdinal));
        }
    }

    private boolean setJobStatusToStarting() {
        JobStatus status = this.jobStatus();
        if (status == JobStatus.COMPLETED || status == JobStatus.FAILED) {
            this.logger.severe("Cannot init job " + Util.idToString(this.jobId) + ": it is already " + (Object)((Object)status));
            return false;
        }
        if (this.cancellationToken.isCompleted()) {
            this.logger.fine("Skipping init job " + Util.idToString(this.jobId) + ": is already cancelled.");
            this.finalizeJob(new CancellationException());
            return false;
        }
        if (status == JobStatus.NOT_STARTED) {
            if (!this.jobStatus.compareAndSet(JobStatus.NOT_STARTED, JobStatus.STARTING)) {
                this.logger.fine("Cannot init job " + Util.idToString(this.jobId) + ": someone else is just starting it");
                return false;
            }
            this.jobStartTime = System.currentTimeMillis();
        }
        if ((status = this.jobStatus()) != JobStatus.STARTING && status != JobStatus.RESTARTING) {
            this.logger.severe("Cannot init job " + Util.idToString(this.jobId) + ": status is " + (Object)((Object)status));
            return false;
        }
        return true;
    }

    private boolean scheduleRestartIfQuorumAbsent() {
        int quorumSize = this.jobRecord.getQuorumSize();
        if (this.coordinationService.isQuorumPresent(quorumSize)) {
            return false;
        }
        this.logger.fine("Rescheduling restart of job " + Util.idToString(this.jobId) + ": quorum size " + quorumSize + " is not met");
        this.scheduleRestart();
        return true;
    }

    private boolean scheduleRestartIfClusterIsNotSafe() {
        if (this.coordinationService.shouldStartJobs()) {
            return false;
        }
        this.logger.fine("Rescheduling restart of job " + Util.idToString(this.jobId) + ": cluster is not safe");
        this.scheduleRestart();
        return true;
    }

    private void scheduleRestart() {
        this.jobStatus.compareAndSet(JobStatus.RUNNING, JobStatus.RESTARTING);
        this.coordinationService.scheduleRestart(this.jobId);
    }

    private MembersView getMembersView() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.nodeEngine.getClusterService();
        return clusterService.getMembershipManager().getMembersView();
    }

    private DAG deserializeDAG() {
        ClassLoader cl = this.coordinationService.getClassLoader(this.jobId);
        return (DAG)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), cl, this.jobRecord.getDag());
    }

    private void onInitStepCompleted(Map<MemberInfo, Object> responses) {
        JobStatus status;
        Throwable error = this.getInitResult(responses);
        if (error == null && (status = this.jobStatus()) != JobStatus.STARTING && status != JobStatus.RESTARTING) {
            error = new IllegalStateException("Cannot execute " + this.jobIdString() + ": status is " + (Object)((Object)status));
        }
        if (error == null) {
            this.invokeStartExecution();
        } else {
            this.invokeCompleteExecution(error);
        }
    }

    private Throwable getInitResult(Map<MemberInfo, Object> responses) {
        if (this.cancellationToken.isCompleted()) {
            this.logger.fine(this.jobIdString() + " to be cancelled after init");
            return new CancellationException();
        }
        Map<Boolean, List<Map.Entry<MemberInfo, Object>>> grouped = this.groupResponses(responses);
        Collection successfulMembers = grouped.get(false).stream().map(Map.Entry::getKey).collect(Collectors.toList());
        if (successfulMembers.size() == this.executionPlanMap.size()) {
            this.logger.fine("Init of " + this.jobIdString() + " is successful.");
            return null;
        }
        List<Map.Entry<MemberInfo, Object>> failures = grouped.get(true);
        this.logger.fine("Init of " + this.jobIdString() + " failed with: " + failures);
        return failures.stream().map(e -> (Throwable)e.getValue()).filter(t -> !ExceptionUtil.isTopologicalFailure(t)).findFirst().map(ExceptionUtil::peel).orElse(new TopologyChangedException());
    }

    private Map<Boolean, List<Map.Entry<MemberInfo, Object>>> groupResponses(Map<MemberInfo, Object> responses) {
        Map<Boolean, List<Map.Entry<MemberInfo, Object>>> grouped = responses.entrySet().stream().collect(Collectors.partitioningBy(e -> e.getValue() instanceof Throwable));
        grouped.putIfAbsent(true, Collections.emptyList());
        grouped.putIfAbsent(false, Collections.emptyList());
        return grouped;
    }

    private void invokeStartExecution() {
        this.logger.fine("Executing " + this.jobIdString());
        long executionId = this.executionId;
        ExecutionInvocationCallback callback = new ExecutionInvocationCallback(executionId);
        this.cancellationToken.whenCompleted(callback::cancelInvocations);
        CompletionToken executionRestartToken = new CompletionToken(this.logger);
        executionRestartToken.whenCompleted(callback::cancelInvocations);
        Function<ExecutionPlan, Operation> operationCtor = plan -> new StartExecutionOperation(this.jobId, executionId);
        Consumer<Map<MemberInfo, Object>> completionCallback = results -> {
            this.executionRestartToken = null;
            this.onExecuteStepCompleted((Map<MemberInfo, Object>)results, executionRestartToken.isCompleted());
        };
        this.executionRestartToken = executionRestartToken;
        this.jobStatus.set(JobStatus.RUNNING);
        this.invoke(operationCtor, completionCallback, callback);
        if (this.isSnapshottingEnabled()) {
            this.coordinationService.scheduleSnapshot(this.jobId, executionId);
        }
    }

    private void cancelExecutionInvocations(long jobId, long executionId) {
        this.nodeEngine.getExecutionService().execute("hz:async", () -> {
            Function<ExecutionPlan, Operation> operationCtor = plan -> new CancelExecutionOperation(jobId, executionId);
            this.invoke(operationCtor, responses -> {}, null);
        });
    }

    boolean restartExecution() {
        CompletionToken restartToken = this.executionRestartToken;
        if (restartToken != null) {
            restartToken.complete();
            return true;
        }
        return false;
    }

    void beginSnapshot(long executionId) {
        if (this.executionId != executionId) {
            this.logger.warning("Not beginning snapshot since expected execution id " + Util.idToString(this.executionId) + " does not match to " + Util.jobAndExecutionId(this.jobId, executionId));
            return;
        }
        List<String> vertexNames = this.vertices.stream().map(Vertex::getName).collect(Collectors.toList());
        long newSnapshotId = this.snapshotRepository.registerSnapshot(this.jobId, vertexNames);
        this.logger.info(String.format("Starting snapshot %s for %s", newSnapshotId, Util.jobAndExecutionId(this.jobId, executionId)));
        Function<ExecutionPlan, Operation> factory = plan -> new SnapshotOperation(this.jobId, executionId, newSnapshotId);
        this.invoke(factory, responses -> this.onSnapshotCompleted((Map<MemberInfo, Object>)responses, executionId, newSnapshotId), null);
    }

    private void onSnapshotCompleted(Map<MemberInfo, Object> responses, long executionId, long snapshotId) {
        Map<Address, Throwable> errors = responses.entrySet().stream().filter(e -> e.getValue() instanceof Throwable).filter(e -> !(e.getValue() instanceof CancellationException) || !ExceptionUtil.isTopologicalFailure(e.getValue())).collect(Collectors.toMap(e -> ((MemberInfo)e.getKey()).getAddress(), e -> (Throwable)e.getValue()));
        boolean isSuccess = errors.isEmpty();
        if (!isSuccess) {
            this.logger.warning(Util.jobAndExecutionId(this.jobId, executionId) + " snapshot " + snapshotId + " has failures: " + errors);
        }
        this.coordinationService.completeSnapshot(this.jobId, executionId, snapshotId, isSuccess);
    }

    private void onExecuteStepCompleted(Map<MemberInfo, Object> responses, boolean isRestartRequested) {
        this.invokeCompleteExecution(this.getExecuteResult(responses, isRestartRequested));
    }

    private Throwable getExecuteResult(Map<MemberInfo, Object> responses, boolean isRestartRequested) {
        if (this.cancellationToken.isCompleted()) {
            this.logger.fine(this.jobIdString() + " to be cancelled after execute");
            return new CancellationException();
        }
        if (isRestartRequested) {
            return new JobRestartRequestedException();
        }
        Map<Boolean, List<Map.Entry<MemberInfo, Object>>> grouped = this.groupResponses(responses);
        Collection successfulMembers = grouped.get(false).stream().map(Map.Entry::getKey).collect(Collectors.toList());
        if (successfulMembers.size() == this.executionPlanMap.size()) {
            this.logger.fine("Execute of " + this.jobIdString() + " is successful.");
            return null;
        }
        List<Map.Entry<MemberInfo, Object>> failures = grouped.get(true);
        this.logger.fine("Execute of " + this.jobIdString() + " has failures: " + failures);
        return failures.stream().map(e -> (Throwable)e.getValue()).filter(t -> !(t instanceof CancellationException) && !ExceptionUtil.isTopologicalFailure(t)).findFirst().map(ExceptionUtil::peel).orElse(new TopologyChangedException());
    }

    private void invokeCompleteExecution(Throwable error) {
        Throwable finalError;
        JobStatus status = this.jobStatus();
        if (status == JobStatus.STARTING || status == JobStatus.RESTARTING || status == JobStatus.RUNNING) {
            this.logger.fine("Completing " + this.jobIdString());
            finalError = error;
        } else {
            if (error != null) {
                this.logger.severe("Cannot properly complete failed " + this.jobIdString() + ": status is " + (Object)((Object)status), error);
            } else {
                this.logger.severe("Cannot properly complete " + this.jobIdString() + ": status is " + (Object)((Object)status));
            }
            finalError = new IllegalStateException("Job coordination failed.");
        }
        Function<ExecutionPlan, Operation> operationCtor = plan -> new CompleteExecutionOperation(this.executionId, finalError);
        this.invoke(operationCtor, responses -> this.finalizeJob(error), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeJob(@Nullable Throwable failure) {
        if (this.assertJobNotAlreadyDone(failure)) {
            return;
        }
        this.completeVertices(failure);
        if (this.shouldRestart(failure)) {
            this.scheduleRestart();
            return;
        }
        long elapsed = System.currentTimeMillis() - this.jobStartTime;
        if (this.isSuccess(failure)) {
            this.logger.info(String.format("Execution of %s completed in %,d ms", this.jobIdString(), elapsed));
        } else {
            this.logger.warning(String.format("Execution of %s failed after %,d ms", this.jobIdString(), elapsed), failure);
        }
        try {
            this.coordinationService.completeJob(this, this.executionId, System.currentTimeMillis(), failure);
        }
        catch (RuntimeException e) {
            this.logger.warning("Completion of " + this.jobIdString() + " failed", failure);
        }
        finally {
            this.setFinalResult(failure);
        }
    }

    private boolean assertJobNotAlreadyDone(@Nullable Throwable failure) {
        JobStatus status = this.jobStatus();
        if (status == JobStatus.COMPLETED || status == JobStatus.FAILED) {
            if (failure != null) {
                this.logger.severe("Ignoring failure completion of " + Util.idToString(this.jobId) + " because status is " + (Object)((Object)status), failure);
            } else {
                this.logger.severe("Ignoring completion of " + Util.idToString(this.jobId) + " because status is " + (Object)((Object)status));
            }
            return true;
        }
        return false;
    }

    private void completeVertices(@Nullable Throwable failure) {
        if (this.vertices != null) {
            for (Vertex vertex : this.vertices) {
                try {
                    vertex.getMetaSupplier().close(failure);
                }
                catch (Exception e) {
                    this.logger.severe(this.jobIdString() + " encountered an exception in ProcessorMetaSupplier.complete(), ignoring it", e);
                }
            }
        }
    }

    private boolean shouldRestart(Throwable t) {
        return t instanceof JobRestartRequestedException || t instanceof TopologyChangedException && this.jobRecord.getConfig().isAutoRestartOnMemberFailureEnabled();
    }

    void setFinalResult(Throwable failure) {
        JobStatus status = this.isSuccess(failure) ? JobStatus.COMPLETED : JobStatus.FAILED;
        this.jobStatus.set(status);
        if (failure == null) {
            this.completionFuture.internalComplete();
        } else {
            this.completionFuture.internalCompleteExceptionally(failure);
        }
    }

    private boolean isSuccess(Throwable failure) {
        return failure == null || failure instanceof CancellationException;
    }

    private void invoke(Function<ExecutionPlan, Operation> operationCtor, Consumer<Map<MemberInfo, Object>> completionCallback, ExecutionCallback<Object> callback) {
        CompletableFuture<Void> doneFuture = new CompletableFuture<Void>();
        ConcurrentHashMap<MemberInfo, InternalCompletableFuture<Object>> futures = new ConcurrentHashMap<MemberInfo, InternalCompletableFuture<Object>>();
        this.invokeOnParticipants(futures, doneFuture, operationCtor);
        doneFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.logger, (aVoid, throwable) -> {
            HashMap responses = new HashMap();
            for (Map.Entry entry : futures.entrySet()) {
                Object val;
                try {
                    val = ((InternalCompletableFuture)entry.getValue()).get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    val = e;
                }
                catch (Exception e) {
                    val = ExceptionUtil.peel(e);
                }
                responses.put(entry.getKey(), val);
            }
            completionCallback.accept(responses);
        }));
        if (callback != null) {
            futures.values().forEach(f -> f.andThen(callback));
        }
    }

    private void invokeOnParticipants(Map<MemberInfo, InternalCompletableFuture<Object>> futures, CompletableFuture<Void> doneFuture, Function<ExecutionPlan, Operation> opCtor) {
        AtomicInteger remainingCount = new AtomicInteger(this.executionPlanMap.size());
        for (Map.Entry<MemberInfo, ExecutionPlan> e : this.executionPlanMap.entrySet()) {
            MemberInfo member = e.getKey();
            Operation op = opCtor.apply(e.getValue());
            InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", op, member.getAddress()).setDoneCallback(() -> {
                if (remainingCount.decrementAndGet() == 0) {
                    doneFuture.complete(null);
                }
            }).invoke();
            futures.put(member, future);
        }
    }

    private boolean isSnapshottingEnabled() {
        return this.getJobConfig().getProcessingGuarantee() != ProcessingGuarantee.NONE;
    }

    private String jobIdString() {
        return Util.jobAndExecutionId(this.jobId, this.executionId);
    }

    private static ClassLoader swapContextClassLoader(ClassLoader jobClassLoader) {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(jobClassLoader);
        return contextClassLoader;
    }

    private class ExecutionInvocationCallback
    implements ExecutionCallback<Object> {
        private final AtomicBoolean invocationsCancelled = new AtomicBoolean();
        private final long executionId;

        ExecutionInvocationCallback(long executionId) {
            this.executionId = executionId;
        }

        @Override
        public void onResponse(Object response) {
        }

        @Override
        public void onFailure(Throwable t) {
            this.cancelInvocations();
        }

        void cancelInvocations() {
            if (this.invocationsCancelled.compareAndSet(false, true)) {
                MasterContext.this.cancelExecutionInvocations(MasterContext.this.jobId, this.executionId);
            }
        }
    }

    private static class SnapshotRestoreEdge
    extends Edge {
        SnapshotRestoreEdge(Vertex source, Vertex destination, int destOrdinal) {
            super(source, 0, destination, destOrdinal);
            this.distributed();
            this.partitioned(DistributedFunctions.entryKey());
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }
    }
}

