/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.logging.ILogger;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface ProcessorSupplier
extends Serializable {
    default public void init(@Nonnull Context context) {
    }

    @Nonnull
    public Collection<? extends Processor> get(int var1);

    default public void close(@Nullable Throwable error) {
    }

    @Nonnull
    public static ProcessorSupplier of(@Nonnull DistributedSupplier<? extends Processor> processorSupplier) {
        return count -> Stream.generate(processorSupplier).limit(count).collect(Collectors.toList());
    }

    public static interface Context
    extends ProcessorMetaSupplier.Context {
        @Override
        @Nonnull
        public ILogger logger();

        public int memberIndex();
    }
}

