/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

public final class JetDataSerializerHook
implements DataSerializerHook {
    @Override
    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new DAG();
                }
                case 2: {
                    return new Edge();
                }
                case 1: {
                    return new Vertex();
                }
                case 3: {
                    return new HazelcastWriters.ApplyFnEntryProcessor();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

