/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class K8sUtils {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final long MINIMUM_OVERHEAD = 384L;

    private K8sUtils() {
    }

    public static String calculateMemoryWithDefaultOverhead(String memory) {
        long memoryMB = K8sUtils.convertToBytes(memory) / 0x100000L;
        long memoryOverheadMB = Math.max((long)((float)memoryMB * 0.1f), 384L);
        return memoryMB + memoryOverheadMB + "Mi";
    }

    public static String calculateSparkMemory(String memory, String memoryOverhead) {
        long memoryMB = K8sUtils.convertToBytes(memory) / 0x100000L;
        long memoryOverheadMB = K8sUtils.convertToBytes(memoryOverhead) / 0x100000L;
        return memoryMB + memoryOverheadMB + "Mi";
    }

    private static long convertToBytes(String memory) {
        String lower = memory.toLowerCase().trim();
        Matcher m = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
        if (!m.matches()) {
            throw new NumberFormatException("Failed to parse string: " + memory);
        }
        long value = Long.parseLong(m.group(1));
        String suffix = m.group(2);
        long memoryAmountBytes = value;
        if (StringUtils.containsIgnoreCase(suffix, "k")) {
            memoryAmountBytes = value * 1024L;
        } else if (StringUtils.containsIgnoreCase(suffix, "m")) {
            memoryAmountBytes = value * 0x100000L;
        } else if (StringUtils.containsIgnoreCase(suffix, "g")) {
            memoryAmountBytes = value * 0x40000000L;
        } else if (StringUtils.containsIgnoreCase(suffix, "t")) {
            memoryAmountBytes = value * 0x10000000000L;
        }
        if (0L > memoryAmountBytes) {
            throw new NumberFormatException("Conversion of " + memory + " exceeds Long.MAX_VALUE");
        }
        return memoryAmountBytes;
    }
}

