/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.zeppelinhub;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.OldNoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.OldNotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.repo.zeppelinhub.ZeppelinHubRepo;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.Instance;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.UserSessionContainer;
import org.apache.zeppelin.notebook.repo.zeppelinhub.model.UserTokenContainer;
import org.apache.zeppelin.notebook.repo.zeppelinhub.rest.ZeppelinhubRestApiHandler;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.Client;
import org.apache.zeppelin.notebook.repo.zeppelinhub.websocket.utils.ZeppelinhubUtils;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldZeppelinHubRepo
implements OldNotebookRepoWithVersionControl {
    private static final Logger LOG = LoggerFactory.getLogger(ZeppelinHubRepo.class);
    private static final String DEFAULT_SERVER = "https://www.zeppelinhub.com";
    static final String ZEPPELIN_CONF_PROP_NAME_SERVER = "zeppelinhub.api.address";
    static final String ZEPPELIN_CONF_PROP_NAME_TOKEN = "zeppelinhub.api.token";
    private static final Gson GSON = new Gson();
    private static final Note EMPTY_NOTE = new Note();
    private Client websocketClient;
    private UserTokenContainer tokenManager;
    private String token;
    private ZeppelinhubRestApiHandler restApiClient;
    private ZeppelinConfiguration conf;

    public OldZeppelinHubRepo() {
    }

    public OldZeppelinHubRepo(ZeppelinConfiguration conf) {
        this();
        this.init(conf);
    }

    public void init(ZeppelinConfiguration conf) {
        this.conf = conf;
        String zeppelinHubUrl = this.getZeppelinHubUrl(conf);
        LOG.info("Initializing ZeppelinHub integration module");
        this.token = conf.getString("ZEPPELINHUB_API_TOKEN", ZEPPELIN_CONF_PROP_NAME_TOKEN, "");
        this.restApiClient = ZeppelinhubRestApiHandler.newInstance((String)zeppelinHubUrl);
        this.tokenManager = UserTokenContainer.init((ZeppelinhubRestApiHandler)this.restApiClient, (String)this.token);
        this.websocketClient = Client.initialize((String)this.getZeppelinWebsocketUri(conf), (String)this.getZeppelinhubWebsocketUri(conf), (String)this.token, (ZeppelinConfiguration)conf);
        this.websocketClient.start();
    }

    private String getZeppelinHubWsUri(URI api) throws URISyntaxException {
        URI apiRoot = api;
        String scheme = apiRoot.getScheme();
        int port = apiRoot.getPort();
        if (port <= 0) {
            int n = port = scheme != null && scheme.equals("https") ? 443 : 80;
        }
        if (scheme == null) {
            LOG.info("{} is not a valid zeppelinhub server address. proceed with default address {}", (Object)apiRoot, (Object)DEFAULT_SERVER);
            apiRoot = new URI(DEFAULT_SERVER);
            scheme = apiRoot.getScheme();
            port = apiRoot.getPort();
            if (port <= 0) {
                port = scheme != null && scheme.equals("https") ? 443 : 80;
            }
        }
        String ws = scheme.equals("https") ? "wss://" : "ws://";
        return ws + apiRoot.getHost() + ":" + port + "/async";
    }

    String getZeppelinhubWebsocketUri(ZeppelinConfiguration conf) {
        String zeppelinHubUri = "";
        try {
            zeppelinHubUri = this.getZeppelinHubWsUri(new URI(conf.getString("ZEPPELINHUB_API_ADDRESS", ZEPPELIN_CONF_PROP_NAME_SERVER, DEFAULT_SERVER)));
        }
        catch (URISyntaxException e) {
            LOG.error("Cannot get ZeppelinHub URI", (Throwable)e);
        }
        return zeppelinHubUri;
    }

    private String getZeppelinWebsocketUri(ZeppelinConfiguration conf) {
        int port = conf.getServerPort();
        if (port <= 0) {
            port = 80;
        }
        String ws = conf.useSsl() ? "wss" : "ws";
        return ws + "://localhost:" + port + "/ws";
    }

    void setZeppelinhubRestApiHandler(ZeppelinhubRestApiHandler zeppelinhub) {
        this.restApiClient = zeppelinhub;
    }

    String getZeppelinHubUrl(ZeppelinConfiguration conf) {
        String zeppelinhubUrl;
        URI apiRoot;
        if (conf == null) {
            LOG.error("Invalid configuration, cannot be null. Using default address {}", (Object)DEFAULT_SERVER);
            return DEFAULT_SERVER;
        }
        try {
            String url = conf.getString("ZEPPELINHUB_API_ADDRESS", ZEPPELIN_CONF_PROP_NAME_SERVER, DEFAULT_SERVER);
            apiRoot = new URI(url);
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid zeppelinhub url, using default address {}", (Object)DEFAULT_SERVER, (Object)e);
            return DEFAULT_SERVER;
        }
        String scheme = apiRoot.getScheme();
        if (scheme == null) {
            LOG.info("{} is not a valid zeppelinhub server address. proceed with default address {}", (Object)apiRoot, (Object)DEFAULT_SERVER);
            zeppelinhubUrl = DEFAULT_SERVER;
        } else {
            zeppelinhubUrl = scheme + "://" + apiRoot.getHost();
            if (apiRoot.getPort() > 0) {
                zeppelinhubUrl = zeppelinhubUrl + ":" + apiRoot.getPort();
            }
        }
        return zeppelinhubUrl;
    }

    private boolean isSubjectValid(AuthenticationInfo subject) {
        if (subject == null) {
            return false;
        }
        return !subject.isAnonymous() || this.conf.isAnonymousAllowed();
    }

    public List<OldNoteInfo> list(AuthenticationInfo subject) throws IOException {
        if (!this.isSubjectValid(subject)) {
            return Collections.emptyList();
        }
        String token = this.getUserToken(subject.getUser());
        String response = this.restApiClient.get(token, "");
        List notes = (List)GSON.fromJson(response, new TypeToken<List<OldNoteInfo>>(){}.getType());
        if (notes == null) {
            return Collections.emptyList();
        }
        LOG.info("ZeppelinHub REST API listing notes ");
        return notes;
    }

    public Note get(String noteId, AuthenticationInfo subject) throws IOException {
        if (StringUtils.isBlank((String)noteId) || !this.isSubjectValid(subject)) {
            return EMPTY_NOTE;
        }
        String token = this.getUserToken(subject.getUser());
        String response = this.restApiClient.get(token, noteId);
        Note note = Note.fromJson((String)response);
        if (note == null) {
            return EMPTY_NOTE;
        }
        LOG.info("ZeppelinHub REST API get note {} ", (Object)noteId);
        return note;
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        if (note == null || !this.isSubjectValid(subject)) {
            throw new IOException("Zeppelinhub failed to save note");
        }
        String jsonNote = note.toJson();
        String token = this.getUserToken(subject.getUser());
        LOG.info("ZeppelinHub REST API saving note {} ", (Object)note.getId());
        this.restApiClient.put(token, jsonNote);
    }

    public void remove(String noteId, AuthenticationInfo subject) throws IOException {
        if (StringUtils.isBlank((String)noteId) || !this.isSubjectValid(subject)) {
            throw new IOException("Zeppelinhub failed to remove note");
        }
        String token = this.getUserToken(subject.getUser());
        LOG.info("ZeppelinHub REST API removing note {} ", (Object)noteId);
        this.restApiClient.del(token, noteId);
    }

    public void close() {
        this.websocketClient.stop();
        this.restApiClient.close();
    }

    public OldNotebookRepoWithVersionControl.Revision checkpoint(String noteId, String checkpointMsg, AuthenticationInfo subject) throws IOException {
        if (StringUtils.isBlank((String)noteId) || !this.isSubjectValid(subject)) {
            return OldNotebookRepoWithVersionControl.Revision.EMPTY;
        }
        String endpoint = Joiner.on((String)"/").join((Object)noteId, (Object)"checkpoint", new Object[0]);
        String content = GSON.toJson((Object)ImmutableMap.of((Object)"message", (Object)checkpointMsg));
        String token = this.getUserToken(subject.getUser());
        String response = this.restApiClient.putWithResponseBody(token, endpoint, content);
        return (OldNotebookRepoWithVersionControl.Revision)GSON.fromJson(response, OldNotebookRepoWithVersionControl.Revision.class);
    }

    public Note get(String noteId, String revId, AuthenticationInfo subject) throws IOException {
        if (StringUtils.isBlank((String)noteId) || StringUtils.isBlank((String)revId) || !this.isSubjectValid(subject)) {
            return EMPTY_NOTE;
        }
        String endpoint = Joiner.on((String)"/").join((Object)noteId, (Object)"checkpoint", new Object[]{revId});
        String token = this.getUserToken(subject.getUser());
        String response = this.restApiClient.get(token, endpoint);
        Note note = Note.fromJson((String)response);
        if (note == null) {
            return EMPTY_NOTE;
        }
        LOG.info("ZeppelinHub REST API get note {} revision {}", (Object)noteId, (Object)revId);
        return note;
    }

    public List<OldNotebookRepoWithVersionControl.Revision> revisionHistory(String noteId, AuthenticationInfo subject) {
        if (StringUtils.isBlank((String)noteId) || !this.isSubjectValid(subject)) {
            return Collections.emptyList();
        }
        String endpoint = Joiner.on((String)"/").join((Object)noteId, (Object)"checkpoint", new Object[0]);
        List history = Collections.emptyList();
        try {
            String token = this.getUserToken(subject.getUser());
            String response = this.restApiClient.get(token, endpoint);
            history = (List)GSON.fromJson(response, new TypeToken<List<OldNotebookRepoWithVersionControl.Revision>>(){}.getType());
        }
        catch (IOException e) {
            LOG.error("Cannot get note history", (Throwable)e);
        }
        return history;
    }

    private String getUserToken(String user) {
        return this.tokenManager.getUserToken(user);
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        List<Instance> instances;
        if (!this.isSubjectValid(subject)) {
            return Collections.emptyList();
        }
        ArrayList settings = Lists.newArrayList();
        String user = subject.getUser();
        String zeppelinHubUserSession = UserSessionContainer.instance.getSession(user);
        String userToken = this.getUserToken(user);
        LinkedList values = Lists.newLinkedList();
        try {
            instances = this.tokenManager.getUserInstances(zeppelinHubUserSession);
        }
        catch (IOException e) {
            LOG.warn("Couldnt find instances for the session {}, returning empty collection", (Object)zeppelinHubUserSession);
            instances = Collections.emptyList();
        }
        NotebookRepoSettingsInfo repoSetting = NotebookRepoSettingsInfo.newInstance();
        repoSetting.type = NotebookRepoSettingsInfo.Type.DROPDOWN;
        for (Instance instance : instances) {
            if (instance.token.equals(userToken)) {
                repoSetting.selected = Integer.toString(instance.id);
            }
            values.add(ImmutableMap.of((Object)"name", (Object)instance.name, (Object)"value", (Object)Integer.toString(instance.id)));
        }
        repoSetting.value = values;
        repoSetting.name = "Instance";
        settings.add(repoSetting);
        return settings;
    }

    private void changeToken(int instanceId, String user) {
        if (instanceId <= 0) {
            LOG.error("User {} tried to switch to a non valid instance {}", (Object)user, (Object)instanceId);
            return;
        }
        LOG.info("User {} will switch instance", (Object)user);
        String ticket = UserSessionContainer.instance.getSession(user);
        String currentToken = "";
        String targetToken = "";
        try {
            List instances = this.tokenManager.getUserInstances(ticket);
            if (instances.isEmpty()) {
                return;
            }
            currentToken = this.tokenManager.getExistingUserToken(user);
            for (Instance instance : instances) {
                if (instance.id != instanceId) continue;
                LOG.info("User {} switched to instance {}", (Object)user, (Object)instance.name);
                this.tokenManager.setUserToken(user, instance.token);
                targetToken = instance.token;
                break;
            }
            if (!StringUtils.isBlank((String)currentToken) && !StringUtils.isBlank((String)targetToken)) {
                ZeppelinhubUtils.userSwitchTokenRoutine((String)user, (String)currentToken, (String)targetToken);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot switch instance for user {}", (Object)user, (Object)e);
        }
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        if (!this.isSubjectValid(subject)) {
            LOG.error("Invalid subject, cannot update Zeppelinhub settings");
            return;
        }
        if (settings == null || settings.isEmpty()) {
            LOG.error("Cannot update ZeppelinHub repo settings because of invalid settings");
            return;
        }
        int instanceId = 0;
        if (settings.containsKey("Instance")) {
            try {
                instanceId = Integer.parseInt(settings.get("Instance"));
            }
            catch (NumberFormatException e) {
                LOG.error("ZeppelinHub Instance Id in not a valid integer", (Throwable)e);
            }
        }
        this.changeToken(instanceId, subject.getUser());
    }

    public Note setNoteRevision(String noteId, String revId, AuthenticationInfo subject) throws IOException {
        return null;
    }
}

