/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.util;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;

public class IdHashes {
    private static final char[] DICTIONARY = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    private static String encode(Long value) {
        ArrayList<Character> result = new ArrayList<Character>();
        BigInteger base = new BigInteger("" + DICTIONARY.length);
        int exponent = 1;
        BigInteger remaining = new BigInteger(value.toString());
        while (true) {
            BigInteger a = base.pow(exponent);
            BigInteger b = remaining.mod(a);
            BigInteger c = base.pow(exponent - 1);
            BigInteger d = b.divide(c);
            result.add(Character.valueOf(DICTIONARY[d.intValue()]));
            remaining = remaining.subtract(b);
            if (remaining.equals(BigInteger.ZERO)) break;
            ++exponent;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = result.size() - 1; i >= 0; --i) {
            sb.append(result.get(i));
        }
        return sb.toString();
    }

    public static String generateId() {
        return IdHashes.encode(System.currentTimeMillis() + (long)new SecureRandom().nextInt());
    }
}

