/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInlineClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInlineClassLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.IrReplacementFunction;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.MemoizedInlineClassReplacements;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010)\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010*\u001a\u00020\u0016H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010*\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010-\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u00010\u001e0.0&2\u0006\u0010*\u001a\u00020\u00162\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u001e2\u0006\u00100\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000fH\u0016J\u0010\u0010;\u001a\u00020\u001e2\u0006\u00100\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0014H\u0016J\u0010\u0010>\u001a\u00020\u001e2\u0006\u00100\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u00100\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u001e2\u0006\u00100\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u001e2\u0006\u00100\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u001e2\u0006\u00100\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020JH\u0002J$\u0010K\u001a\u00020\r*\u0002012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "manager", "Lorg/jetbrains/kotlin/backend/jvm/lower/inlineclasses/MemoizedInlineClassReplacements;", "valueMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "buildBoxFunction", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "buildPrimaryInlineClassConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReplacementCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "originalFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "original", "replacement", "Lorg/jetbrains/kotlin/backend/jvm/lower/inlineclasses/IrReplacementFunction;", "buildUnboxFunction", "coerceInlineClasses", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "from", "Lorg/jetbrains/kotlin/ir/types/IrType;", "to", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformConstructorFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "constructor", "transformFunctionFlat", "function", "transformSimpleFunctionFlat", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "typedArgumentList", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitFunctionAccess", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitStatementContainer", "container", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "buildReplacement", "backend.jvm"})
final class JvmInlineClassLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    private final MemoizedInlineClassReplacements manager;
    private final Map<IrValueSymbol, IrValueDeclaration> valueMap;
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        this.transformChildrenVoid(irFile);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(declaration2);
        if (irConstructor != null) {
            IrConstructor irConstructor2 = irConstructor;
            boolean bl = false;
            boolean bl2 = false;
            IrConstructor it = irConstructor2;
            boolean bl3 = false;
            IrReplacementFunction irReplacementFunction = this.manager.getGetReplacementFunction().invoke(it);
            if (irReplacementFunction != null) {
                IrReplacementFunction irReplacementFunction2 = irReplacementFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                IrReplacementFunction replacement2 = irReplacementFunction2;
                boolean bl6 = false;
                this.valueMap.putAll(replacement2.getValueParameterMap());
            }
        }
        TransformKt.transformDeclarationsFlat(declaration2, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
            final /* synthetic */ JvmInlineClassLowering this$0;

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration memberDeclaration) {
                List list2;
                Intrinsics.checkParameterIsNotNull(memberDeclaration, "memberDeclaration");
                if (memberDeclaration instanceof IrFunction) {
                    list2 = JvmInlineClassLowering.access$transformFunctionFlat(this.this$0, (IrFunction)memberDeclaration);
                } else {
                    memberDeclaration.accept(this.this$0, null);
                    list2 = null;
                }
                return list2;
            }
            {
                this.this$0 = jvmInlineClassLowering;
                super(1);
            }
        });
        if (declaration2.isInline()) {
            IrConstructor irConstructor3 = IrUtilsKt.getPrimaryConstructor(declaration2);
            if (irConstructor3 == null) {
                Intrinsics.throwNpe();
            }
            IrConstructor irConstructor4 = irConstructor3;
            declaration2.getDeclarations().removeIf(visitClass.3.INSTANCE);
            this.buildPrimaryInlineClassConstructor(declaration2, irConstructor4);
            this.buildBoxFunction(declaration2);
            this.buildUnboxFunction(declaration2);
        }
        return declaration2;
    }

    private final List<IrDeclaration> transformFunctionFlat(IrFunction function2) {
        List<IrDeclaration> list2;
        if (InlineClassAbiKt.isPrimaryInlineClassConstructor(function2)) {
            return null;
        }
        IrReplacementFunction replacement2 = this.manager.getGetReplacementFunction().invoke(function2);
        if (replacement2 == null) {
            this.transformChildrenVoid(function2);
            return null;
        }
        IrFunction irFunction = function2;
        if (irFunction instanceof IrSimpleFunction) {
            list2 = this.transformSimpleFunctionFlat((IrSimpleFunction)function2, replacement2);
        } else if (irFunction instanceof IrConstructor) {
            list2 = this.transformConstructorFlat((IrConstructor)function2, replacement2);
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    private final List<IrDeclaration> transformSimpleFunctionFlat(IrSimpleFunction function2, IrReplacementFunction replacement2) {
        IrFunction worker = replacement2.getFunction();
        this.valueMap.putAll(replacement2.getValueParameterMap());
        Iterable $this$forEach$iv = worker.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        IrBody irBody = function2.getBody();
        worker.setBody(irBody != null && (irBody = irBody.transform(this, null)) != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, worker) : null);
        if (function2.getOverriddenSymbols().isEmpty() || worker.getDispatchReceiverParameter() != null) {
            return CollectionsKt.listOf(worker);
        }
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$run = declarationIrBuilder;
        boolean bl3 = false;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$run, worker);
        boolean bl4 = false;
        boolean bl5 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl6 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default($this$apply, function2, 0, 2, null);
        for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(function2)) {
            IrValueParameter newParameter;
            if (replacement2.getValueParameterMap().get(parameter.getSymbol()) == null) {
                continue;
            }
            IrMemberAccessExpressionKt.putArgument($this$apply, newParameter, ExpressionHelpersKt.irGet($this$run, parameter));
        }
        IrFunctionAccessExpression call2 = irFunctionAccessExpression;
        function2.setBody(ExpressionHelpersKt.irExprBody($this$run, call2));
        return CollectionsKt.listOf(worker, function2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformConstructorFlat(IrConstructor constructor, IrReplacementFunction replacement2) {
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        IrFunction worker = replacement2.getFunction();
        this.valueMap.putAll(replacement2.getValueParameterMap());
        Object $this$forEach$iv = worker.getValueParameters();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        $this$forEach$iv = LowerUtilsKt.createIrBuilder$default(this.context, worker.getSymbol(), 0, 0, 6, null);
        IrFunction irFunction = worker;
        boolean $i$f$irBlockBody = false;
        iterator2 = $this$irBlockBody$iv;
        int element$iv = ((IrElement)worker).getStartOffset();
        int endOffset$iv$iv = ((IrElement)worker).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder this_$iv$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv$iv;
        boolean bl = false;
        IrVariable thisVar = ExpressionHelpersKt.irTemporaryVarDeclaration($this$irBlockBody, worker.getReturnType(), "$this", false);
        IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass(constructor).getThisReceiver();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        this.valueMap.put((IrValueSymbol)irValueParameter.getSymbol(), thisVar);
        Object object = constructor.getBody();
        if (object != null && (object = JvmInlineClassLoweringKt.access$getContents$p((IrBody)object)) != null) {
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrStatement statement2 = (IrStatement)element$iv2;
                boolean bl2 = false;
                $this$irBlockBody.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)statement2.transform(new IrElementTransformerVoid($this$irBlockBody, thisVar, this, worker, constructor){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody$inlined;
                    final /* synthetic */ IrVariable $thisVar$inlined;
                    final /* synthetic */ JvmInlineClassLowering this$0;
                    final /* synthetic */ IrFunction $worker$inlined;
                    final /* synthetic */ IrConstructor $constructor$inlined;
                    {
                        this.$this_irBlockBody$inlined = irBlockBodyBuilder;
                        this.$thisVar$inlined = irVariable2;
                        this.this$0 = jvmInlineClassLowering;
                        this.$worker$inlined = irFunction;
                        this.$constructor$inlined = irConstructor;
                    }

                    @NotNull
                    public IrStatement visitClass(@NotNull IrClass declaration2) {
                        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                        return declaration2;
                    }

                    @NotNull
                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkParameterIsNotNull(expression2, "expression");
                        this.transformChildrenVoid(expression2);
                        return ExpressionHelpersKt.irSetVar(this.$this_irBlockBody$inlined, (IrVariableSymbol)this.$thisVar$inlined.getSymbol(), expression2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public IrExpression visitReturn(@NotNull IrReturn expression2) {
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock$iv;
                        Intrinsics.checkParameterIsNotNull(expression2, "expression");
                        this.transformChildrenVoid(expression2);
                        if (Intrinsics.areEqual(expression2.getReturnTargetSymbol(), (IrConstructorSymbol)this.$constructor$inlined.getSymbol()) ^ true) {
                            return expression2;
                        }
                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody$inlined;
                        int n = expression2.getStartOffset();
                        int n2 = expression2.getEndOffset();
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody$inlined;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        IrBlockBuilder $this$irBlock = this_$iv$iv;
                        boolean bl = false;
                        $this$irBlock.unaryPlus(expression2.getValue());
                        $this$irBlock.unaryPlus(ExpressionHelpersKt.irGet($this$irBlock, this.$thisVar$inlined));
                        IrExpression irExpression = this_$iv$iv.doBuild();
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, irExpression);
                    }
                }, null).transform(this, null), worker));
            }
        }
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn($this$irBlockBody, ExpressionHelpersKt.irGet($this$irBlockBody, thisVar)));
        IrBlockBody irBlockBody2 = this_$iv$iv$iv.doBuild();
        irFunction.setBody(irBlockBody2);
        return CollectionsKt.listOf(worker);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IrValueParameter, IrExpression>> typedArgumentList(IrFunction function2, IrMemberAccessExpression expression2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<IrValueParameter, IrExpression> pair;
        Pair<IrValueParameter, IrExpression> pair2;
        Pair<IrValueParameter, IrExpression> pair3;
        IrValueParameter it;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        int n;
        Object object3;
        Pair[] pairArray = new Pair[2];
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        int n2 = 0;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            object3 = irValueParameter;
            n = n2;
            object2 = pairArray2;
            object = pairArray3;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl3 = false;
            pair3 = TuplesKt.to(it, expression2.getDispatchReceiver());
            pairArray3 = object;
            pairArray2 = object2;
            n2 = n;
            pair2 = pair3;
        } else {
            pair2 = null;
        }
        pairArray2[n2] = pair2;
        Pair[] pairArray4 = pairArray3;
        Pair[] pairArray5 = pairArray3;
        int n3 = 1;
        IrValueParameter irValueParameter2 = function2.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            object3 = irValueParameter2;
            n = n3;
            object2 = pairArray4;
            object = pairArray5;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl4 = false;
            pair3 = TuplesKt.to(it, expression2.getExtensionReceiver());
            pairArray5 = object;
            pairArray4 = object2;
            n3 = n;
            pair = pair3;
        } else {
            pair = null;
        }
        pairArray4[n3] = pair;
        object3 = function2.getValueParameters();
        object = CollectionsKt.listOfNotNull(pairArray5);
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl5 = false;
            Pair<void, IrExpression> pair4 = TuplesKt.to(it2, expression2.getValueArgument(it2.getIndex()));
            object2.add(pair4);
        }
        object2 = (List)destination$iv$iv;
        return CollectionsKt.plus(object, (Iterable)object2);
    }

    private final void buildReplacement(@NotNull IrMemberAccessExpression $this$buildReplacement, IrFunction originalFunction, IrMemberAccessExpression original, IrReplacementFunction replacement2) {
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom($this$buildReplacement, original);
        for (Pair<IrValueParameter, IrExpression> pair : this.typedArgumentList(originalFunction, original)) {
            IrValueParameter newParameter;
            IrValueParameter parameter = pair.component1();
            IrExpression argument = pair.component2();
            if (argument == null) continue;
            if (replacement2.getValueParameterMap().get(parameter.getSymbol()) == null) {
                continue;
            }
            IrMemberAccessExpressionKt.putArgument($this$buildReplacement, replacement2.getFunction(), newParameter, argument.transform(this, null));
        }
    }

    private final IrFunctionAccessExpression buildReplacementCall(IrFunction originalFunction, IrFunctionAccessExpression original, IrReplacementFunction replacement2) {
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default(this.context, original.getSymbol(), 0, 0, 6, null), replacement2.getFunction());
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl3 = false;
        this.buildReplacement($this$apply, originalFunction, original, replacement2);
        return irFunctionAccessExpression;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrReplacementFunction irReplacementFunction = this.manager.getGetReplacementFunction().invoke(expression2.getSymbol().getOwner());
        if (irReplacementFunction == null) {
            return super.visitFunctionReference(expression2);
        }
        IrReplacementFunction replacement2 = irReplacementFunction;
        IrFunction function2 = replacement2.getFunction();
        IrFunctionReferenceImpl irFunctionReferenceImpl = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), function2.getSymbol(), function2.getDescriptor(), function2.getTypeParameters().size(), function2.getValueParameters().size(), expression2.getOrigin());
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionReferenceImpl $this$apply = irFunctionReferenceImpl;
        boolean bl3 = false;
        this.buildReplacement($this$apply, expression2.getSymbol().getOwner(), expression2, replacement2);
        return irFunctionReferenceImpl;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrFunction function2 = expression2.getSymbol().getOwner();
        IrReplacementFunction irReplacementFunction = this.manager.getGetReplacementFunction().invoke(function2);
        if (irReplacementFunction == null) {
            return super.visitFunctionAccess(expression2);
        }
        IrReplacementFunction replacement2 = irReplacementFunction;
        return this.buildReplacementCall(function2, expression2, replacement2);
    }

    private final IrCallImpl coerceInlineClasses(IrExpression argument, IrType from, IrType to) {
        IrCallImpl irCallImpl = new IrCallImpl(-1, -1, to, this.context.getIr().getSymbols().getUnsafeCoerceIntrinsicSymbol());
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl3 = false;
        $this$apply.putTypeArgument(0, from);
        $this$apply.putTypeArgument(1, to);
        $this$apply.putValueArgument(0, argument);
        return irCallImpl;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (!InlineClassAbiKt.isInlineClassFieldGetter(function2)) {
            return super.visitCall(expression2);
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        IrExpression arg = irExpression.transform(this, null);
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        return this.coerceInlineClasses(arg, irValueParameter.getType(), expression2.getType());
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrDeclarationParent parent2 = field.getParent();
        if (parent2 instanceof IrClass && ((IrClass)parent2).isInline() && Intrinsics.areEqual(field.getName(), InlineClassAbiKt.getInlineClassFieldName((IrClass)parent2))) {
            IrExpression irExpression = expression2.getReceiver();
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            IrExpression receiver = irExpression.transform(this, null);
            return this.coerceInlineClasses(receiver, receiver.getType(), field.getType());
        }
        return super.visitGetField(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        block2: {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            IrReturnTarget $this$safeAs$iv = expression2.getReturnTargetSymbol().getOwner();
            boolean $i$f$safeAs = false;
            IrReturnTarget irReturnTarget = $this$safeAs$iv;
            if (!(irReturnTarget instanceof IrFunction)) {
                irReturnTarget = null;
            }
            IrFunction irFunction = (IrFunction)irReturnTarget;
            if (irFunction == null) break block2;
            IrFunction irFunction2 = irFunction;
            boolean bl = false;
            boolean bl2 = false;
            IrFunction target = irFunction2;
            boolean bl3 = false;
            IrReplacementFunction irReplacementFunction = this.manager.getGetReplacementFunction().invoke(target);
            if (irReplacementFunction != null) {
                IrReplacementFunction irReplacementFunction2 = irReplacementFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                IrReplacementFunction it = irReplacementFunction2;
                boolean bl6 = false;
                return ExpressionHelpersKt.irReturn(LowerUtilsKt.createIrBuilder$default(this.context, it.getFunction().getSymbol(), 0, 0, 6, null), expression2.getValue().transform(this, null));
            }
        }
        return super.visitReturn(expression2);
    }

    private final void visitStatementContainer(IrStatementContainer container2) {
        List<IrStatement> $this$transformFlat$iv = container2.getStatements();
        boolean $i$f$transformFlat = false;
        int i$iv = 0;
        while (i$iv < $this$transformFlat$iv.size()) {
            List<IrDeclaration> transformed$iv;
            IrStatement item$iv;
            IrStatement statement2 = item$iv = $this$transformFlat$iv.get(i$iv);
            boolean bl = false;
            List<IrStatement> list2 = transformed$iv = statement2 instanceof IrFunction ? this.transformFunctionFlat((IrFunction)statement2) : CollectionsKt.listOf(statement2.transform(this, null));
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $this$transformFlat$iv.addAll(i$iv, (Collection<IrStatement>)transformed$iv);
            $this$transformFlat$iv.remove(i$iv += transformed$iv.size());
        }
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        this.visitStatementContainer(expression2);
        return expression2;
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.visitStatementContainer(body);
        return body;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration irValueDeclaration2 = irValueDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            IrValueDeclaration it = irValueDeclaration2;
            boolean bl3 = false;
            return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
        }
        return super.visitGetValue(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration irValueDeclaration2 = irValueDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            IrValueDeclaration it = irValueDeclaration2;
            boolean bl3 = false;
            IrValueSymbol irValueSymbol = it.getSymbol();
            if (irValueSymbol == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrVariableSymbol");
            }
            IrSetVariableImpl irSetVariableImpl = new IrSetVariableImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrVariableSymbol)irValueSymbol, expression2.getOrigin());
            boolean bl4 = false;
            boolean bl5 = false;
            IrSetVariableImpl $this$apply = irSetVariableImpl;
            boolean bl6 = false;
            $this$apply.setValue(expression2.getValue().transform(this, null));
            return irSetVariableImpl;
        }
        return super.visitSetVariable(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPrimaryInlineClassConstructor(IrClass irClass, IrConstructor irConstructor) {
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        IrTypeParametersContainer $this$addConstructor$iv = irClass;
        boolean $i$f$addConstructor = false;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$run$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$buildConstructor$iv = $this$run$iv$iv;
        int n = 0;
        IrFunctionBuilder $this$addConstructor = $this$buildConstructor$iv;
        boolean bl4 = false;
        $this$addConstructor.updateFrom(irConstructor);
        Visibility visibility = Visibilities.PRIVATE;
        Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PRIVATE");
        $this$addConstructor.setVisibility(visibility);
        $this$addConstructor.setOrigin(JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE);
        $this$addConstructor.setReturnType(irConstructor.getReturnType());
        $this$buildConstructor$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$run$iv$iv);
        boolean bl5 = false;
        bl = false;
        Object constructor$iv = irConstructor2;
        boolean $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent($this$addConstructor$iv);
        $this$addConstructor$iv = irConstructor2;
        boolean bl6 = false;
        boolean bl7 = false;
        IrTypeParametersContainer $this$apply = $this$addConstructor$iv;
        boolean bl8 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)$this$apply, irConstructor);
        constructor$iv = LowerUtilsKt.createIrBuilder$default(this.context, $this$apply.getSymbol(), 0, 0, 6, null);
        IrTypeParametersContainer $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = $this$apply;
        boolean $i$f$irBlockBody = false;
        $this$buildConstructor$iv = $this$irBlockBody$iv;
        n = ((IrElement)$this$apply).getStartOffset();
        int endOffset$iv$iv = ((IrElement)$this$apply).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder this_$iv$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv$iv;
        boolean bl9 = false;
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall($this$irBlockBody, SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$irBlockBody.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = $this$irBlockBody;
        IrBuilderWithScope irBuilderWithScope2 = $this$irBlockBody;
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), InlineClassesKt.getInlineClassBackingField(irClass), ExpressionHelpersKt.irGet($this$irBlockBody, $this$apply.getValueParameters().get(0))));
        IrBlockBody irBlockBody2 = this_$iv$iv$iv.doBuild();
        $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22.setBody(irBlockBody2);
        IrReplacementFunction irReplacementFunction = this.manager.getGetReplacementFunction().invoke(irConstructor);
        if (irReplacementFunction == null) {
            Intrinsics.throwNpe();
        }
        IrFunction function2 = irReplacementFunction.getFunction();
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        bl7 = false;
        boolean bl10 = false;
        DeclarationIrBuilder $this$with = object;
        boolean bl11 = false;
        IrValueParameter argument = function2.getValueParameters().get(0);
        function2.setBody(ExpressionHelpersKt.irExprBody($this$with, this.coerceInlineClasses(ExpressionHelpersKt.irGet($this$with, argument), argument.getType(), function2.getReturnType())));
        object = irClass.getDeclarations();
        bl7 = false;
        object.add(function2);
    }

    private final void buildBoxFunction(IrClass irClass) {
        IrSimpleFunction function2 = this.manager.getGetBoxFunction().invoke(irClass);
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = object;
        boolean bl3 = false;
        IrBuilderWithScope irBuilderWithScope = $this$with;
        IrBuilderWithScope irBuilderWithScope2 = $this$with;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(irClass);
        if (irConstructor == null) {
            Intrinsics.throwNpe();
        }
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall(irBuilderWithScope2, (IrConstructorSymbol)irConstructor.getSymbol());
        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl4 = false;
        boolean bl5 = false;
        IrConstructorCall $this$apply = irConstructorCall;
        boolean bl6 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default($this$apply, function2, 0, 2, null);
        $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$with, function2.getValueParameters().get(0)));
        IrConstructorCall irConstructorCall2 = irConstructorCall;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope3, irConstructorCall2));
        object = irClass.getDeclarations();
        bl = false;
        object.add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUnboxFunction(IrClass irClass) {
        void $this$irBlockBody$iv;
        IrSimpleFunction function2 = this.manager.getGetUnboxFunction().invoke(irClass);
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        IrField field = InlineClassesKt.getInlineClassBackingField(irClass);
        Object object = builder;
        IrSimpleFunction irSimpleFunction = function2;
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv;
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = $this$irBlockBody;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        IrGetValueImpl thisVal = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn($this$irBlockBody, ExpressionHelpersKt.irGetField($this$irBlockBody, thisVal, field)));
        IrBlockBody irBlockBody2 = this_$iv$iv.doBuild();
        irSimpleFunction.setBody(irBlockBody2);
        object = irClass.getDeclarations();
        boolean bl2 = false;
        object.add(function2);
    }

    public JvmInlineClassLowering(@NotNull JvmBackendContext context2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
        this.manager = new MemoizedInlineClassReplacements();
        JvmInlineClassLowering jvmInlineClassLowering = this;
        boolean bl = false;
        jvmInlineClassLowering.valueMap = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ List access$transformFunctionFlat(JvmInlineClassLowering $this, IrFunction function2) {
        return $this.transformFunctionFlat(function2);
    }
}

