/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.repl.building;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import org.apache.zeppelin.kotlin.context.KotlinReceiver;

public class KotlinReplProperties {
    private ScriptingHostConfiguration hostConf = JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration();
    private KotlinReceiver receiver = new KotlinReceiver();
    private Set<String> classpath = new HashSet<String>();
    private List<String> codeOnLoad;
    private String outputDir;
    private int maxResult = 1000;
    private boolean shortenTypes = true;

    public KotlinReplProperties() {
        String[] javaClasspath = System.getProperty("java.class.path").split(File.pathSeparator);
        Collections.addAll(this.classpath, javaClasspath);
        this.codeOnLoad = new ArrayList<String>();
    }

    public KotlinReplProperties receiver(KotlinReceiver receiver) {
        this.receiver = receiver;
        return this;
    }

    public KotlinReplProperties classPath(String path2) {
        this.classpath.add(path2);
        return this;
    }

    public KotlinReplProperties classPath(Collection<String> paths) {
        this.classpath.addAll(paths);
        return this;
    }

    public KotlinReplProperties codeOnLoad(String code) {
        this.codeOnLoad.add(code);
        return this;
    }

    public KotlinReplProperties codeOnLoad(Collection<String> code) {
        this.codeOnLoad.addAll(code);
        return this;
    }

    public KotlinReplProperties outputDir(String outputDir2) {
        this.outputDir = outputDir2;
        return this;
    }

    public KotlinReplProperties maxResult(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public KotlinReplProperties shortenTypes(boolean shortenTypes) {
        this.shortenTypes = shortenTypes;
        return this;
    }

    public ScriptingHostConfiguration getHostConf() {
        return this.hostConf;
    }

    public KotlinReceiver getReceiver() {
        return this.receiver;
    }

    public Set<String> getClasspath() {
        return this.classpath;
    }

    public List<String> getCodeOnLoad() {
        return this.codeOnLoad;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public boolean getShortenTypes() {
        return this.shortenTypes;
    }
}

