/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.kotlin.completion.KotlinKeywords;
import org.apache.zeppelin.kotlin.reflect.KotlinFunctionInfo;
import org.apache.zeppelin.kotlin.reflect.KotlinReflectUtil;
import org.apache.zeppelin.kotlin.reflect.KotlinVariableInfo;
import org.apache.zeppelin.kotlin.repl.KotlinRepl;

public class KotlinCompleter {
    private static final List<InterpreterCompletion> keywords = KotlinKeywords.KEYWORDS.stream().map(keyword -> new InterpreterCompletion(keyword, keyword, null)).collect(Collectors.toList());
    private KotlinRepl.KotlinContext ctx;

    public void setCtx(KotlinRepl.KotlinContext ctx2) {
        this.ctx = ctx2;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        if (this.ctx == null) {
            return new ArrayList<InterpreterCompletion>(keywords);
        }
        ArrayList<InterpreterCompletion> result2 = new ArrayList<InterpreterCompletion>();
        for (KotlinVariableInfo var : this.ctx.getVars()) {
            result2.add(new InterpreterCompletion(var.getName(), var.getName(), KotlinReflectUtil.shorten(var.getType())));
        }
        for (KotlinFunctionInfo fun : this.ctx.getFunctions()) {
            result2.add(new InterpreterCompletion(fun.getName(), fun.getName(), fun.toString(true)));
        }
        result2.addAll(keywords);
        return result2;
    }
}

