/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.kotlin;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.kotlin.completion.KotlinCompleter;
import org.apache.zeppelin.kotlin.context.KotlinReceiver;
import org.apache.zeppelin.kotlin.reflect.KotlinFunctionInfo;
import org.apache.zeppelin.kotlin.reflect.KotlinVariableInfo;
import org.apache.zeppelin.kotlin.repl.KotlinRepl;
import org.apache.zeppelin.kotlin.repl.building.KotlinReplProperties;
import org.apache.zeppelin.scheduler.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinInterpreter
extends Interpreter {
    private static Logger logger = LoggerFactory.getLogger(KotlinInterpreter.class);
    private InterpreterOutputStream out;
    private KotlinRepl interpreter;
    private KotlinReplProperties replProperties = new KotlinReplProperties();
    private KotlinCompleter completer;

    public KotlinInterpreter(Properties properties2) {
        super(properties2);
        int maxResult = Integer.parseInt(properties2.getProperty("zeppelin.kotlin.maxResult", "1000"));
        boolean shortenTypes = Boolean.parseBoolean(properties2.getProperty("zeppelin.kotlin.shortenTypes", "true"));
        String imports = properties2.getProperty("zeppelin.interpreter.localRepo", "");
        this.completer = new KotlinCompleter();
        this.replProperties.receiver(new KotlinReceiver()).maxResult(maxResult).codeOnLoad("").classPath(this.getImportClasspath(imports)).shortenTypes(shortenTypes);
    }

    public KotlinReplProperties getKotlinReplProperties() {
        return this.replProperties;
    }

    public void open() throws InterpreterException {
        this.interpreter = new KotlinRepl(this.replProperties);
        this.completer.setCtx(this.interpreter.getKotlinContext());
        this.out = new InterpreterOutputStream(logger);
    }

    public void close() {
    }

    public InterpreterResult interpret(String code, InterpreterContext context2) throws InterpreterException {
        Job<?> runningJob = this.getRunningJob(context2.getParagraphId());
        if (runningJob != null) {
            runningJob.info().put("CURRENT_THREAD", Thread.currentThread());
        }
        return this.runWithOutput(code, context2.out);
    }

    public void cancel(InterpreterContext context2) throws InterpreterException {
        Map info2;
        Object object;
        Job<?> runningJob = this.getRunningJob(context2.getParagraphId());
        if (runningJob != null && (object = (info2 = runningJob.info()).get("CURRENT_THREAD")) instanceof Thread) {
            try {
                Thread t = (Thread)object;
                t.interrupt();
            }
            catch (Throwable t) {
                logger.error("Failed to cancel script: " + t, t);
            }
        }
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context2) throws InterpreterException {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        return this.completer.completion(buf, cursor, interpreterContext);
    }

    public List<KotlinVariableInfo> getVariables() {
        return this.interpreter.getVariables();
    }

    public List<KotlinFunctionInfo> getFunctions() {
        return this.interpreter.getFunctions();
    }

    private Job<?> getRunningJob(String paragraphId) {
        Job foundJob = null;
        List jobsRunning = this.getScheduler().getAllJobs();
        for (Job job : jobsRunning) {
            if (!job.getId().equals(paragraphId)) continue;
            foundJob = job;
        }
        return foundJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult runWithOutput(String code, InterpreterOutput out) {
        this.out.setInterpreterOutput(out);
        PrintStream oldOut = System.out;
        PrintStream newOut = out != null ? new PrintStream((OutputStream)out) : null;
        try {
            System.setOut(newOut);
            InterpreterResult interpreterResult = this.interpreter.eval(code);
            return interpreterResult;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    private List<String> getImportClasspath(String localRepo) {
        ArrayList<String> classpath2 = new ArrayList<String>();
        if (localRepo.equals("")) {
            return classpath2;
        }
        File repo = new File(localRepo);
        File[] files2 = repo.listFiles();
        if (files2 == null) {
            return classpath2;
        }
        for (File file2 : files2) {
            if (!file2.isFile()) continue;
            classpath2.add(file2.getAbsolutePath());
        }
        return classpath2;
    }
}

