/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.hive;

import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.jdbc.JDBCInterpreter;
import org.apache.zeppelin.jdbc.hive.ProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveUtils.class);
    private static final int DEFAULT_QUERY_PROGRESS_INTERVAL = 1000;
    private static final Pattern JOBURL_PATTERN = Pattern.compile(".*Tracking URL = (\\S*).*", 32);

    public static void startHiveMonitorThread(Statement stmt, InterpreterContext context, boolean displayLog, JDBCInterpreter jdbcInterpreter) {
        HiveStatement hiveStmt = (HiveStatement)((DelegatingStatement)((DelegatingStatement)stmt).getDelegate()).getDelegate();
        String hiveVersion = HiveVersionInfo.getVersion();
        ProgressBar progressBarTemp = null;
        if (HiveUtils.isProgressBarSupported(hiveVersion)) {
            LOGGER.debug("ProgressBar is supported for hive version: " + hiveVersion);
            progressBarTemp = new ProgressBar();
        } else {
            LOGGER.debug("ProgressBar is not supported for hive version: " + hiveVersion);
        }
        ProgressBar progressBar = progressBarTemp;
        long timeoutThreshold = Long.parseLong(jdbcInterpreter.getProperty("zeppelin.jdbc.hive.timeout.threshold", "60000"));
        Thread thread = new Thread(() -> {
            boolean jobLaunched = false;
            long jobLastActiveTime = System.currentTimeMillis();
            while (hiveStmt.hasMoreLogs() && !Thread.interrupted()) {
                try {
                    Optional<String> jobURL;
                    List logs = hiveStmt.getQueryLog();
                    String logsOutput = StringUtils.join(logs, System.lineSeparator());
                    LOGGER.debug("Hive job output: " + logsOutput);
                    boolean displayLogProperty = context.getBooleanLocalProperty("displayLog", displayLog);
                    if (!StringUtils.isBlank(logsOutput) && displayLogProperty) {
                        context.out.write(logsOutput + "\n");
                        context.out.flush();
                    }
                    if (!StringUtils.isBlank(logsOutput) && progressBar != null && displayLogProperty) {
                        progressBar.operationLogShowedToUser();
                    }
                    if ((jobURL = HiveUtils.extractMRJobURL(logsOutput)).isPresent()) {
                        HashMap<String, String> infos = new HashMap<String, String>();
                        infos.put("jobUrl", jobURL.get());
                        infos.put("label", "HIVE JOB");
                        infos.put("tooltip", "View in YARN WEB UI");
                        infos.put("noteId", context.getNoteId());
                        infos.put("paraId", context.getParagraphId());
                        context.getIntpEventClient().onParaInfosReceived(infos);
                    }
                    if (logsOutput.contains("Launching Job")) {
                        jobLaunched = true;
                    }
                    if (jobLaunched) {
                        if (StringUtils.isNotBlank(logsOutput)) {
                            jobLastActiveTime = System.currentTimeMillis();
                        } else if (progressBar.getBeelineInPlaceUpdateStream() != null && progressBar.getBeelineInPlaceUpdateStream().getLastUpdateTimestamp() > jobLastActiveTime) {
                            jobLastActiveTime = progressBar.getBeelineInPlaceUpdateStream().getLastUpdateTimestamp();
                        }
                        if (System.currentTimeMillis() - jobLastActiveTime > timeoutThreshold) {
                            String errorMessage = "Cancel this job as no more log is produced in the last " + timeoutThreshold / 1000L + " seconds, maybe it is because no yarn resources";
                            LOGGER.warn(errorMessage);
                            jdbcInterpreter.cancel(context, errorMessage);
                            try {
                                if (hiveStmt.isClosed()) break;
                            }
                            catch (SQLException e) {
                                LOGGER.warn("hiveStmt closed unnormally", e);
                            }
                            break;
                        }
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to write output", e);
                }
                finally {
                    try {
                        if (!hiveStmt.isClosed()) continue;
                        break;
                    }
                    catch (SQLException e) {
                        LOGGER.warn("hiveStmt closed unnormally", e);
                    }
                }
            }
            LOGGER.info("HiveMonitor-Thread is finished");
        });
        thread.setName("HiveMonitor-Thread");
        thread.setDaemon(true);
        thread.start();
        LOGGER.info("Start HiveMonitor-Thread for sql: " + hiveStmt);
        if (progressBar != null) {
            progressBar.setInPlaceUpdateStream(hiveStmt, (OutputStream)context.out);
        }
    }

    private static boolean isProgressBarSupported(String hiveVersion) {
        String[] tokens = hiveVersion.split("\\.");
        int majorVersion = Integer.parseInt(tokens[0]);
        int minorVersion = Integer.parseInt(tokens[1]);
        return majorVersion > 2 || majorVersion == 2 && minorVersion >= 3;
    }

    static Optional<String> extractMRJobURL(String log) {
        Matcher matcher = JOBURL_PATTERN.matcher(log);
        if (matcher.matches()) {
            String jobURL = matcher.group(1);
            return Optional.of(jobURL);
        }
        return Optional.empty();
    }
}

