/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.zeppelin.user.UsernamePassword;

public class JDBCUserConfigurations {
    private final Map<String, Statement> paragraphIdStatementMap = new HashMap<String, Statement>();
    private final Map<String, PoolingDriver> poolingDriverMap = new HashMap<String, PoolingDriver>();
    private final HashMap<String, Properties> propertiesMap = new HashMap();
    private HashMap<String, Boolean> isSuccessful = new HashMap();

    public void initStatementMap() throws SQLException {
        for (Statement statement : this.paragraphIdStatementMap.values()) {
            statement.close();
        }
        this.paragraphIdStatementMap.clear();
    }

    public void initConnectionPoolMap() throws SQLException {
        this.poolingDriverMap.clear();
        this.isSuccessful.clear();
    }

    public void setPropertyMap(String dbPrefix, Properties properties) {
        Properties p = (Properties)properties.clone();
        this.propertiesMap.put(dbPrefix, p);
    }

    public Properties getPropertyMap(String key) {
        return this.propertiesMap.get(key);
    }

    public void cleanUserProperty(String dfPrefix) {
        this.propertiesMap.get(dfPrefix).remove("user");
        this.propertiesMap.get(dfPrefix).remove("password");
    }

    public void setUserProperty(String dbPrefix, UsernamePassword usernamePassword) {
        this.propertiesMap.get(dbPrefix).setProperty("user", usernamePassword.getUsername());
        this.propertiesMap.get(dbPrefix).setProperty("password", usernamePassword.getPassword());
    }

    public void saveStatement(String paragraphId, Statement statement) throws SQLException {
        this.paragraphIdStatementMap.put(paragraphId, statement);
    }

    public void cancelStatement(String paragraphId) throws SQLException {
        this.paragraphIdStatementMap.get(paragraphId).cancel();
    }

    public void removeStatement(String paragraphId) {
        this.paragraphIdStatementMap.remove(paragraphId);
    }

    public void saveDBDriverPool(String dbPrefix, PoolingDriver driver) throws SQLException {
        this.poolingDriverMap.put(dbPrefix, driver);
        this.isSuccessful.put(dbPrefix, false);
    }

    public PoolingDriver removeDBDriverPool(String key) throws SQLException {
        this.isSuccessful.remove(key);
        return this.poolingDriverMap.remove(key);
    }

    public boolean isConnectionInDBDriverPool(String key) {
        return this.poolingDriverMap.containsKey(key);
    }

    public void setConnectionInDBDriverPoolSuccessful(String dbPrefix) {
        this.isSuccessful.put(dbPrefix, true);
    }
}

