/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.base.Preconditions;
import io.atomix.core.transaction.AsyncTransaction;
import io.atomix.core.transaction.CommitStatus;
import io.atomix.core.transaction.Isolation;
import io.atomix.core.transaction.Transaction;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionalMapBuilder;
import io.atomix.core.transaction.TransactionalSetBuilder;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingTransaction
implements Transaction {
    private final AsyncTransaction asyncTransaction;
    private final long operationTimeoutMillis;

    public BlockingTransaction(AsyncTransaction asyncTransaction, long operationTimeoutMillis) {
        this.asyncTransaction = (AsyncTransaction)Preconditions.checkNotNull((Object)asyncTransaction);
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    public String name() {
        return this.asyncTransaction.name();
    }

    public PrimitiveType type() {
        return this.asyncTransaction.type();
    }

    public PrimitiveProtocol protocol() {
        return this.asyncTransaction.protocol();
    }

    @Override
    public TransactionId transactionId() {
        return this.asyncTransaction.transactionId();
    }

    @Override
    public Isolation isolation() {
        return this.asyncTransaction.isolation();
    }

    @Override
    public boolean isOpen() {
        return this.asyncTransaction.isOpen();
    }

    @Override
    public void begin() {
        this.complete(this.asyncTransaction.begin());
    }

    @Override
    public CommitStatus commit() {
        return this.complete(this.asyncTransaction.commit());
    }

    @Override
    public void abort() {
        this.complete(this.asyncTransaction.abort());
    }

    @Override
    public <K, V> TransactionalMapBuilder<K, V> mapBuilder(String name) {
        return this.asyncTransaction.mapBuilder(name);
    }

    @Override
    public <E> TransactionalSetBuilder<E> setBuilder(String name) {
        return this.asyncTransaction.setBuilder(name);
    }

    public void close() {
        this.complete(this.asyncTransaction.close());
    }

    @Override
    public AsyncTransaction async() {
        return this.asyncTransaction;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof PrimitiveException) {
                throw (PrimitiveException)e.getCause();
            }
            throw new PrimitiveException(e.getCause());
        }
    }
}

