/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multimap.impl;

import com.google.common.io.BaseEncoding;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.DistributedMultimap;
import io.atomix.core.multimap.DistributedMultimapBuilder;
import io.atomix.core.multimap.DistributedMultimapConfig;
import io.atomix.core.multimap.impl.AtomicMultimapProxy;
import io.atomix.core.multimap.impl.AtomicMultimapService;
import io.atomix.core.multimap.impl.CachingAsyncAtomicMultimap;
import io.atomix.core.multimap.impl.DelegatingAsyncDistributedMultimap;
import io.atomix.core.multimap.impl.TranscodingAsyncAtomicMultimap;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.impl.DelegatingAsyncPrimitive;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedMultimapBuilder<K, V>
extends DistributedMultimapBuilder<K, V> {
    public DefaultDistributedMultimapBuilder(String name, DistributedMultimapConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedMultimap<K, V>> buildAsync() {
        return ((CompletableFuture)((CompletableFuture)this.newProxy(AtomicMultimapService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicMultimapProxy((ProxyClient<AtomicMultimapService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(rawMultimap -> {
            Serializer serializer = this.serializer();
            DelegatingAsyncPrimitive multimap = new TranscodingAsyncAtomicMultimap<Object, Object, String, byte[]>((AsyncAtomicMultimap<String, byte[]>)rawMultimap, key -> BaseEncoding.base16().encode(serializer.encode(key)), string -> serializer.decode(BaseEncoding.base16().decode((CharSequence)string)), value -> serializer.encode(value), bytes -> serializer.decode(bytes));
            if (((DistributedMultimapConfig)this.config).getCacheConfig().isEnabled()) {
                multimap = new CachingAsyncAtomicMultimap(multimap, ((DistributedMultimapConfig)this.config).getCacheConfig());
            }
            return multimap;
        })).thenApply(atomicMultimap -> new DelegatingAsyncDistributedMultimap(atomicMultimap).sync());
    }
}

