/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map.impl;

import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.collection.impl.AsyncDistributedJavaCollection;
import io.atomix.core.map.AsyncDistributedMap;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.DistributedMapType;
import io.atomix.core.map.MapEventListener;
import io.atomix.core.map.impl.BlockingDistributedMap;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.AsyncDistributedJavaSet;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.utils.concurrent.Futures;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncDistributedJavaMap<K, V>
implements AsyncDistributedMap<K, V> {
    private final String name;
    private final PrimitiveProtocol protocol;
    private final Map<K, V> map;

    public AsyncDistributedJavaMap(String name, PrimitiveProtocol protocol, Map<K, V> map) {
        this.name = name;
        this.protocol = protocol;
        this.map = map;
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType type() {
        return DistributedMapType.instance();
    }

    public PrimitiveProtocol protocol() {
        return this.protocol;
    }

    @Override
    public CompletableFuture<Integer> size() {
        return this.complete(() -> this.map.size());
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return this.complete(() -> this.map.isEmpty());
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.complete(() -> this.map.containsKey(key));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(V value) {
        return this.complete(() -> this.map.containsValue(value));
    }

    @Override
    public CompletableFuture<V> get(K key) {
        return this.complete(() -> this.map.get(key));
    }

    @Override
    public CompletableFuture<V> put(K key, V value) {
        return this.complete(() -> this.map.put(key, value));
    }

    @Override
    public CompletableFuture<V> remove(K key) {
        return this.complete(() -> this.map.remove(key));
    }

    @Override
    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> m) {
        return this.complete(() -> this.map.putAll(m));
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.complete(() -> this.map.clear());
    }

    @Override
    public AsyncDistributedSet<K> keySet() {
        return new AsyncDistributedJavaSet<K>(this.name(), this.protocol(), this.map.keySet());
    }

    @Override
    public AsyncDistributedCollection<V> values() {
        return new AsyncDistributedJavaCollection<V>(this.name(), this.protocol(), this.map.values());
    }

    @Override
    public AsyncDistributedSet<Map.Entry<K, V>> entrySet() {
        return new AsyncDistributedJavaSet<Map.Entry<K, V>>(this.name(), this.protocol(), this.map.entrySet());
    }

    @Override
    public CompletableFuture<V> getOrDefault(K key, V defaultValue) {
        return this.complete(() -> this.map.getOrDefault(key, defaultValue));
    }

    @Override
    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.complete(() -> this.map.putIfAbsent(key, value));
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.complete(() -> this.map.remove(key, value));
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.complete(() -> this.map.replace(key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<V> replace(K key, V value) {
        return this.complete(() -> this.map.replace(key, value));
    }

    @Override
    public CompletableFuture<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.complete(() -> this.map.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public CompletableFuture<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.complete(() -> this.map.computeIfPresent(key, remappingFunction));
    }

    @Override
    public CompletableFuture<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.complete(() -> this.map.compute(key, remappingFunction));
    }

    @Override
    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public DistributedMap<K, V> sync(Duration operationTimeout) {
        return new BlockingDistributedMap(this, operationTimeout.toMillis());
    }

    protected CompletableFuture<Void> complete(Runnable runnable) {
        try {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    protected <T> CompletableFuture<T> complete(Supplier<T> supplier) {
        try {
            return CompletableFuture.completedFuture(supplier.get());
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }
}

